/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.provider.Serializer;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

@Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
@XStreamAlias(value="application")
public class Application {
    private String name;
    @XStreamOmitField
    private volatile boolean isDirty = false;
    @XStreamImplicit
    private Set<InstanceInfo> instances;
    private AtomicReference<List<InstanceInfo>> shuffledInstances = new AtomicReference();
    private Map<String, InstanceInfo> instancesMap;

    public Application() {
        this.instances = new LinkedHashSet<InstanceInfo>();
        this.instancesMap = new ConcurrentHashMap<String, InstanceInfo>();
    }

    public Application(String name) {
        this.name = name;
        this.instancesMap = new ConcurrentHashMap<String, InstanceInfo>();
        this.instances = new LinkedHashSet<InstanceInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstance(InstanceInfo i) {
        this.instancesMap.put(i.getId(), i);
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            this.instances.remove(i);
            this.instances.add(i);
            this.isDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstance(InstanceInfo i) {
        this.instancesMap.remove(i.getId());
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            this.instances.remove(i);
            this.isDirty = true;
        }
    }

    public List<InstanceInfo> getInstances() {
        if (this.shuffledInstances.get() == null) {
            return this.getInstancesAsIsFromEureka();
        }
        return this.shuffledInstances.get();
    }

    public List<InstanceInfo> getInstancesAsIsFromEureka() {
        return new ArrayList<InstanceInfo>(this.instances);
    }

    public InstanceInfo getByInstanceId(String id) {
        return this.instancesMap.get(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shuffleAndStoreInstances(boolean filterUpInstances) {
        ArrayList<InstanceInfo> instanceInfoList = null;
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            instanceInfoList = new ArrayList<InstanceInfo>(this.instances);
        }
        if (filterUpInstances) {
            Iterator it = instanceInfoList.iterator();
            while (it.hasNext()) {
                InstanceInfo instanceInfo = (InstanceInfo)it.next();
                if (InstanceInfo.InstanceStatus.UP.equals((Object)instanceInfo.getStatus())) continue;
                it.remove();
            }
        }
        Collections.shuffle(instanceInfoList);
        this.shuffledInstances.set(instanceInfoList);
    }
}

