/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AbstractInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertiesInstanceConfig
extends AbstractInstanceConfig
implements EurekaInstanceConfig {
    private static final String TEST = "test";
    private static final String ARCHAIUS_DEPLOYMENT_ENVIRONMENT = "archaius.deployment.environment";
    private static final String EUREKA_ENVIRONMENT = "eureka.environment";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesInstanceConfig.class);
    protected String namespace = "eureka.";
    private static final DynamicStringProperty EUREKA_PROPS_FILE = DynamicPropertyFactory.getInstance().getStringProperty("eureka.client.props", "eureka-client");
    private static final DynamicPropertyFactory INSTANCE = DynamicPropertyFactory.getInstance();
    private static final String UNKNOWN_APPLICATION = "unknown";
    private String propSecurePort = this.namespace + "securePort";
    private String propSecurePortEnabled = this.propSecurePort + ".enabled";
    private String propNonSecurePort;
    private String propName;
    private String propPortEnabled;
    private String propLeaseRenewalIntervalInSeconds;
    private String propLeaseExpirationDurationInSeconds;
    private String propSecureVirtualHostname;
    private String propVirtualHostname;
    private String propMetadataNamespace;
    private String propASGName;

    public PropertiesInstanceConfig() {
        this.init(this.namespace);
    }

    public PropertiesInstanceConfig(String namespace, DataCenterInfo info) {
        super(info);
        this.init(namespace);
    }

    public PropertiesInstanceConfig(String namespace) {
        this.init(namespace);
    }

    @Override
    public boolean isInstanceEnabledOnit() {
        return INSTANCE.getBooleanProperty(this.namespace + "traffic.enabled", super.isInstanceEnabledOnit()).get();
    }

    @Override
    public int getNonSecurePort() {
        return INSTANCE.getIntProperty(this.propNonSecurePort, super.getNonSecurePort()).get();
    }

    @Override
    public int getSecurePort() {
        return INSTANCE.getIntProperty(this.propSecurePort, super.getSecurePort()).get();
    }

    @Override
    public boolean isNonSecurePortEnabled() {
        return INSTANCE.getBooleanProperty(this.propPortEnabled, super.isNonSecurePortEnabled()).get();
    }

    @Override
    public boolean getSecurePortEnabled() {
        return INSTANCE.getBooleanProperty(this.propSecurePortEnabled, super.getSecurePortEnabled()).get();
    }

    @Override
    public int getLeaseRenewalIntervalInSeconds() {
        return INSTANCE.getIntProperty(this.propLeaseRenewalIntervalInSeconds, super.getLeaseRenewalIntervalInSeconds()).get();
    }

    @Override
    public int getLeaseExpirationDurationInSeconds() {
        return INSTANCE.getIntProperty(this.propLeaseExpirationDurationInSeconds, super.getLeaseExpirationDurationInSeconds()).get();
    }

    @Override
    public String getVirtualHostName() {
        if (this.isNonSecurePortEnabled()) {
            return INSTANCE.getStringProperty(this.propVirtualHostname, super.getVirtualHostName()).get();
        }
        return null;
    }

    @Override
    public String getSecureVirtualHostName() {
        if (this.getSecurePortEnabled()) {
            return INSTANCE.getStringProperty(this.propSecureVirtualHostname, super.getSecureVirtualHostName()).get();
        }
        return null;
    }

    @Override
    public String getASGName() {
        return INSTANCE.getStringProperty(this.propASGName, super.getASGName()).get();
    }

    @Override
    public Map<String, String> getMetadataMap() {
        LinkedHashMap<String, String> metadataMap = new LinkedHashMap<String, String>();
        Configuration config = (Configuration)INSTANCE.getBackingConfigurationSource();
        Iterator iter = config.subset(this.propMetadataNamespace).getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = config.getString(this.propMetadataNamespace + key);
            metadataMap.put(key, value);
        }
        return metadataMap;
    }

    @Override
    public String getAppname() {
        return INSTANCE.getStringProperty(this.propName, UNKNOWN_APPLICATION).get().trim();
    }

    @Override
    public String getIpAddress() {
        return super.getIpAddress();
    }

    private void init(String namespace) {
        this.namespace = namespace;
        this.propSecurePort = namespace + "securePort";
        this.propSecurePortEnabled = this.propSecurePort + ".enabled";
        this.propNonSecurePort = namespace + "port";
        this.propName = namespace + "name";
        this.propPortEnabled = this.propNonSecurePort + ".enabled";
        this.propLeaseRenewalIntervalInSeconds = namespace + "lease.renewalInterval";
        this.propLeaseExpirationDurationInSeconds = namespace + "lease.duration";
        this.propSecureVirtualHostname = namespace + "secureVipAddress";
        this.propVirtualHostname = namespace + "vipAddress";
        this.propMetadataNamespace = namespace + "metadata.";
        this.propASGName = namespace + "asgName";
        String env = ConfigurationManager.getConfigInstance().getString(EUREKA_ENVIRONMENT, TEST);
        ConfigurationManager.getConfigInstance().setProperty(ARCHAIUS_DEPLOYMENT_ENVIRONMENT, (Object)env);
        String eurekaPropsFile = EUREKA_PROPS_FILE.get();
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)eurekaPropsFile);
        }
        catch (IOException e) {
            logger.warn("Cannot find the properties specified : {}. This may be okay if there are other environment specific properties or the configuration is installed with a different mechanism.", (Object)eurekaPropsFile);
        }
    }
}

