/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.converters.Auto;
import com.netflix.discovery.provider.Serializer;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
@XStreamAlias(value="instance")
public class InstanceInfo {
    private static final Logger logger = LoggerFactory.getLogger(InstanceInfo.class);
    private static final Pattern VIP_ATTRIBUTES_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    public static final int DEFAULT_PORT = 7001;
    public static final int DEFAULT_SECURE_PORT = 7002;
    public static final int DEFAULT_COUNTRY_ID = 1;
    private volatile String appName;
    private volatile String ipAddr;
    private volatile String sid = "na";
    private volatile int port = 7001;
    private volatile int securePort = 7002;
    @Auto
    private volatile String homePageUrl;
    @Auto
    private volatile String statusPageUrl;
    @Auto
    private volatile String healthCheckUrl;
    @Auto
    private volatile String secureHealthCheckUrl;
    @Auto
    private volatile String vipAddress;
    @Auto
    private volatile String secureVipAddress;
    @XStreamOmitField
    private String statusPageRelativeUrl;
    @XStreamOmitField
    private String statusPageExplicitUrl;
    @XStreamOmitField
    private String healthCheckRelativeUrl;
    @XStreamOmitField
    private String healthCheckSecureExplicitUrl;
    @XStreamOmitField
    private String vipAddressUnresolved;
    @XStreamOmitField
    private String secureVipAddressUnresolved;
    @XStreamOmitField
    private String healthCheckExplicitUrl;
    @Deprecated
    private volatile int countryId = 1;
    private volatile boolean isSecurePortEnabled = false;
    private volatile boolean isUnsecurePortEnabled = true;
    private volatile DataCenterInfo dataCenterInfo;
    private volatile String hostName;
    private volatile InstanceStatus status = InstanceStatus.UP;
    private volatile InstanceStatus overriddenstatus = InstanceStatus.UNKNOWN;
    @XStreamOmitField
    private volatile boolean isInstanceInfoDirty = false;
    private volatile LeaseInfo leaseInfo;
    @Auto
    private volatile Boolean isCoordinatingDiscoveryServer = Boolean.FALSE;
    @XStreamAlias(value="metadata")
    private volatile Map<String, String> metadata = new ConcurrentHashMap<String, String>();
    @Auto
    private volatile Long lastUpdatedTimestamp = System.currentTimeMillis();
    @Auto
    private volatile Long lastDirtyTimestamp = System.currentTimeMillis();
    @Auto
    private volatile ActionType actionType;
    @Auto
    private volatile String asgName;
    private String version = "unknown";

    private InstanceInfo() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceInfo other = (InstanceInfo)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public String getAppName() {
        return this.appName;
    }

    public String getHostName() {
        return this.hostName;
    }

    @Deprecated
    public void setSID(String sid) {
        this.sid = sid;
        this.setIsDirty(true);
    }

    @Deprecated
    public String getSID() {
        return this.sid;
    }

    public String getId() {
        if (this.dataCenterInfo.getName() == DataCenterInfo.Name.Amazon) {
            return ((AmazonInfo)this.dataCenterInfo).get(AmazonInfo.MetaDataKey.instanceId);
        }
        return this.hostName;
    }

    public String getIPAddr() {
        return this.ipAddr;
    }

    public int getPort() {
        return this.port;
    }

    public InstanceStatus getStatus() {
        return this.status;
    }

    public InstanceStatus getOverriddenStatus() {
        return this.overriddenstatus;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public LeaseInfo getLeaseInfo() {
        return this.leaseInfo;
    }

    public void setLeaseInfo(LeaseInfo info) {
        this.leaseInfo = info;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Deprecated
    public int getCountryId() {
        return this.countryId;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public boolean isPortEnabled(PortType type) {
        if (type == PortType.SECURE) {
            return this.isSecurePortEnabled;
        }
        return this.isUnsecurePortEnabled;
    }

    public long getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public void setLastUpdatedTimestamp() {
        this.lastUpdatedTimestamp = System.currentTimeMillis();
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    public Set<String> getHealthCheckUrls() {
        LinkedHashSet<String> healthCheckUrlSet = new LinkedHashSet<String>();
        if (this.isUnsecurePortEnabled) {
            healthCheckUrlSet.add(this.healthCheckUrl);
        }
        if (this.isSecurePortEnabled) {
            healthCheckUrlSet.add(this.secureHealthCheckUrl);
        }
        return healthCheckUrlSet;
    }

    public String getVIPAddress() {
        return this.vipAddress;
    }

    public String getSecureVipAddress() {
        return this.secureVipAddress;
    }

    public Long getLastDirtyTimestamp() {
        return this.lastDirtyTimestamp;
    }

    public void setLastDirtyTimestamp(Long lastDirtyTimestamp) {
        this.lastDirtyTimestamp = lastDirtyTimestamp;
    }

    public synchronized void setStatus(InstanceStatus status) {
        if (this.status != status) {
            this.status = status;
            this.setIsDirty(true);
        }
    }

    public synchronized void setStatusWithoutDirty(InstanceStatus status) {
        if (this.status != status) {
            this.status = status;
        }
    }

    public synchronized void setOverriddenStatus(InstanceStatus status) {
        if (this.overriddenstatus != status) {
            this.overriddenstatus = status;
        }
    }

    public boolean isDirty() {
        return this.isInstanceInfoDirty;
    }

    public void setIsDirty(boolean b) {
        this.isInstanceInfoDirty = b;
        this.lastDirtyTimestamp = System.currentTimeMillis();
    }

    public void setIsCoordinatingDiscoveryServer() {
        String instanceId = this.getId();
        this.isCoordinatingDiscoveryServer = instanceId != null && instanceId.equals(ApplicationInfoManager.getInstance().getInfo().getId()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isCoordinatingDiscoveryServer() {
        return this.isCoordinatingDiscoveryServer;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public String getASGName() {
        return this.asgName;
    }

    @Deprecated
    public String getVersion() {
        return this.version;
    }

    synchronized void registerRuntimeMetadata(Map<String, String> runtimeMetadata) {
        this.metadata.putAll(runtimeMetadata);
        this.setIsDirty(true);
    }

    private static String resolveDeploymentContextBasedVipAddresses(String vipAddressMacro) {
        String result = vipAddressMacro;
        if (vipAddressMacro == null) {
            return null;
        }
        Matcher matcher = VIP_ATTRIBUTES_PATTERN.matcher(result);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            logger.debug("att:" + matcher.group());
            logger.debug(", att key:" + key);
            logger.debug(", att value:" + value);
            logger.debug("");
            result = result.replaceAll("\\$\\{" + key + "\\}", value);
            matcher = VIP_ATTRIBUTES_PATTERN.matcher(result);
        }
        return result;
    }

    public static enum ActionType {
        ADDED,
        MODIFIED,
        DELETED;

    }

    public static final class Builder {
        private static final String HOSTNAME_INTERPOLATION_EXPRESSION = "${netflix.appinfo.hostname}";
        private static final String COLON = ":";
        private static final String HTTPS_PROTOCOL = "https://";
        private static final String HTTP_PROTOCOL = "http://";
        @XStreamOmitField
        private InstanceInfo result;

        private Builder() {
            this.result = new InstanceInfo();
        }

        public Builder(InstanceInfo instanceInfo) {
            this.result = instanceInfo;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setAppName(String appName) {
            this.result.appName = appName;
            if (this.result.appName != null) {
                this.result.appName = this.result.appName.toUpperCase();
            }
            return this;
        }

        public Builder setHostName(String hostName) {
            String existingHostName = this.result.hostName;
            this.result.hostName = hostName;
            if (existingHostName != null && !hostName.equals(existingHostName)) {
                this.refreshStatusPageUrl().refreshHealthCheckUrl().refreshVIPAddress().refreshSecureVIPAddress();
            }
            return this;
        }

        public Builder setStatus(InstanceStatus status) {
            this.result.status = status;
            return this;
        }

        public Builder setOverriddenStatus(InstanceStatus status) {
            this.result.overriddenstatus = status;
            return this;
        }

        public Builder setIPAddr(String ip) {
            this.result.ipAddr = ip;
            return this;
        }

        @Deprecated
        public Builder setSID(String sid) {
            this.result.sid = sid;
            return this;
        }

        public Builder setPort(int port) {
            this.result.port = port;
            return this;
        }

        public Builder setSecurePort(int port) {
            this.result.securePort = port;
            return this;
        }

        public Builder enablePort(PortType type, boolean isEnabled) {
            if (type == PortType.SECURE) {
                this.result.isSecurePortEnabled = isEnabled;
            } else {
                this.result.isUnsecurePortEnabled = isEnabled;
            }
            return this;
        }

        @Deprecated
        public Builder setCountryId(int id) {
            this.result.countryId = id;
            return this;
        }

        public Builder setHomePageUrl(String relativeUrl, String explicitUrl) {
            if (explicitUrl != null) {
                this.result.homePageUrl = explicitUrl.replace(HOSTNAME_INTERPOLATION_EXPRESSION, this.result.hostName);
            } else if (relativeUrl != null) {
                this.result.homePageUrl = HTTP_PROTOCOL + this.result.hostName + COLON + this.result.port + relativeUrl;
            }
            return this;
        }

        public Builder setStatusPageUrl(String relativeUrl, String explicitUrl) {
            this.result.statusPageRelativeUrl = relativeUrl;
            this.result.statusPageExplicitUrl = explicitUrl;
            if (explicitUrl != null) {
                this.result.statusPageUrl = explicitUrl.replace(HOSTNAME_INTERPOLATION_EXPRESSION, this.result.hostName);
            } else if (relativeUrl != null) {
                this.result.statusPageUrl = HTTP_PROTOCOL + this.result.hostName + COLON + this.result.port + relativeUrl;
            }
            return this;
        }

        public Builder setHealthCheckUrls(String relativeUrl, String explicitUrl, String secureExplicitUrl) {
            this.result.healthCheckRelativeUrl = relativeUrl;
            this.result.healthCheckExplicitUrl = explicitUrl;
            this.result.healthCheckSecureExplicitUrl = secureExplicitUrl;
            if (explicitUrl != null) {
                this.result.healthCheckUrl = explicitUrl.replace(HOSTNAME_INTERPOLATION_EXPRESSION, this.result.hostName);
            } else if (this.result.isUnsecurePortEnabled) {
                this.result.healthCheckUrl = HTTP_PROTOCOL + this.result.hostName + COLON + this.result.port + relativeUrl;
            }
            if (secureExplicitUrl != null) {
                this.result.secureHealthCheckUrl = secureExplicitUrl.replace(HOSTNAME_INTERPOLATION_EXPRESSION, this.result.hostName);
            } else if (this.result.isSecurePortEnabled) {
                this.result.secureHealthCheckUrl = HTTPS_PROTOCOL + this.result.hostName + COLON + this.result.securePort + relativeUrl;
            }
            return this;
        }

        public Builder setVIPAddress(String vipAddress) {
            this.result.vipAddressUnresolved = vipAddress;
            this.result.vipAddress = InstanceInfo.resolveDeploymentContextBasedVipAddresses(vipAddress);
            return this;
        }

        public Builder setSecureVIPAddress(String secureVIPAddress) {
            this.result.secureVipAddressUnresolved = secureVIPAddress;
            this.result.secureVipAddress = InstanceInfo.resolveDeploymentContextBasedVipAddresses(secureVIPAddress);
            return this;
        }

        public Builder setDataCenterInfo(DataCenterInfo datacenter) {
            this.result.dataCenterInfo = datacenter;
            return this;
        }

        public void setLeaseInfo(LeaseInfo info) {
            this.result.leaseInfo = info;
        }

        public Builder add(String key, String val) {
            this.result.metadata.put(key, val);
            return this;
        }

        public Builder setMetadata(Map<String, String> mt) {
            this.result.metadata = mt;
            return this;
        }

        public InstanceInfo getRawInstance() {
            return this.result;
        }

        public InstanceInfo build() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("name is required!");
            }
            return this.result;
        }

        public boolean isInitialized() {
            return this.result.appName != null;
        }

        public Builder setASGName(String asgName) {
            this.result.asgName = asgName;
            return this;
        }

        private Builder refreshStatusPageUrl() {
            this.setStatusPageUrl(this.result.statusPageRelativeUrl, this.result.statusPageExplicitUrl);
            return this;
        }

        private Builder refreshHealthCheckUrl() {
            this.setHealthCheckUrls(this.result.healthCheckRelativeUrl, this.result.healthCheckExplicitUrl, this.result.healthCheckSecureExplicitUrl);
            return this;
        }

        private Builder refreshSecureVIPAddress() {
            this.setSecureVIPAddress(this.result.secureVipAddressUnresolved);
            return this;
        }

        private Builder refreshVIPAddress() {
            this.setVIPAddress(this.result.vipAddressUnresolved);
            return this;
        }
    }

    public static enum PortType {
        SECURE,
        UNSECURE;

    }

    public static enum InstanceStatus {
        UP,
        DOWN,
        STARTING,
        OUT_OF_SERVICE,
        UNKNOWN;


        public static InstanceStatus toEnum(String s) {
            for (InstanceStatus e : InstanceStatus.values()) {
                if (!e.name().equalsIgnoreCase(s)) continue;
                return e;
            }
            return UNKNOWN;
        }
    }
}

