/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.InstanceRegionChecker;
import com.netflix.discovery.provider.Serializer;
import com.netflix.discovery.shared.Applications;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

@Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
@XStreamAlias(value="application")
public class Application {
    private String name;
    @XStreamOmitField
    private volatile boolean isDirty = false;
    @XStreamImplicit
    private final Set<InstanceInfo> instances;
    private AtomicReference<List<InstanceInfo>> shuffledInstances = new AtomicReference();
    private Map<String, InstanceInfo> instancesMap;

    public String toString() {
        return "Application [name=" + this.name + ", isDirty=" + this.isDirty + ", instances=" + this.instances + ", shuffledInstances=" + this.shuffledInstances + ", instancesMap=" + this.instancesMap + "]";
    }

    public Application() {
        this.instances = new LinkedHashSet<InstanceInfo>();
        this.instancesMap = new ConcurrentHashMap<String, InstanceInfo>();
    }

    public Application(String name) {
        this.name = name;
        this.instancesMap = new ConcurrentHashMap<String, InstanceInfo>();
        this.instances = new LinkedHashSet<InstanceInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstance(InstanceInfo i) {
        this.instancesMap.put(i.getId(), i);
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            this.instances.remove(i);
            this.instances.add(i);
            this.isDirty = true;
        }
    }

    public void removeInstance(InstanceInfo i) {
        this.removeInstance(i, true);
    }

    public List<InstanceInfo> getInstances() {
        if (this.shuffledInstances.get() == null) {
            return this.getInstancesAsIsFromEureka();
        }
        return this.shuffledInstances.get();
    }

    public List<InstanceInfo> getInstancesAsIsFromEureka() {
        return new ArrayList<InstanceInfo>(this.instances);
    }

    public InstanceInfo getByInstanceId(String id) {
        return this.instancesMap.get(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void shuffleAndStoreInstances(boolean filterUpInstances) {
        this._shuffleAndStoreInstances(filterUpInstances, false, null, null, null);
    }

    public void shuffleAndStoreInstances(Map<String, Applications> remoteRegionsRegistry, EurekaClientConfig clientConfig, InstanceRegionChecker instanceRegionChecker) {
        this._shuffleAndStoreInstances(clientConfig.shouldFilterOnlyUpInstances(), true, remoteRegionsRegistry, clientConfig, instanceRegionChecker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _shuffleAndStoreInstances(boolean filterUpInstances, boolean indexByRemoteRegions, @Nullable Map<String, Applications> remoteRegionsRegistry, @Nullable EurekaClientConfig clientConfig, @Nullable InstanceRegionChecker instanceRegionChecker) {
        ArrayList<InstanceInfo> instanceInfoList;
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            instanceInfoList = new ArrayList<InstanceInfo>(this.instances);
        }
        if (indexByRemoteRegions || filterUpInstances) {
            Iterator it = instanceInfoList.iterator();
            while (it.hasNext()) {
                Application remoteApp;
                String instanceRegion;
                InstanceInfo instanceInfo = (InstanceInfo)it.next();
                if (filterUpInstances && !InstanceInfo.InstanceStatus.UP.equals((Object)instanceInfo.getStatus())) {
                    it.remove();
                    continue;
                }
                if (!indexByRemoteRegions || null == instanceRegionChecker || null == clientConfig || null == remoteRegionsRegistry || instanceRegionChecker.isLocalRegion(instanceRegion = instanceRegionChecker.getInstanceRegion(instanceInfo))) continue;
                Applications appsForRemoteRegion = remoteRegionsRegistry.get(instanceRegion);
                if (null == appsForRemoteRegion) {
                    appsForRemoteRegion = new Applications();
                    remoteRegionsRegistry.put(instanceRegion, appsForRemoteRegion);
                }
                if (null == (remoteApp = appsForRemoteRegion.getRegisteredApplications(instanceInfo.getAppName()))) {
                    remoteApp = new Application(instanceInfo.getAppName());
                    appsForRemoteRegion.addApplication(remoteApp);
                }
                remoteApp.addInstance(instanceInfo);
                this.removeInstance(instanceInfo, false);
                it.remove();
            }
        }
        Collections.shuffle(instanceInfoList);
        this.shuffledInstances.set(instanceInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInstance(InstanceInfo i, boolean markAsDirty) {
        this.instancesMap.remove(i.getId());
        Set<InstanceInfo> set = this.instances;
        synchronized (set) {
            this.instances.remove(i);
            if (markAsDirty) {
                this.isDirty = true;
            }
        }
    }
}

