/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.governator.guice.lazy.FineGrainedLazySingleton;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FineGrainedLazySingleton
public class ApplicationInfoManager {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInfoManager.class);
    private static ApplicationInfoManager instance = new ApplicationInfoManager();
    private InstanceInfo instanceInfo;
    private EurekaInstanceConfig config;

    private ApplicationInfoManager() {
    }

    @Inject
    ApplicationInfoManager(EurekaInstanceConfig config, InstanceInfo instanceInfo) {
        this.config = config;
        this.instanceInfo = instanceInfo;
        instance = this;
    }

    public static ApplicationInfoManager getInstance() {
        return instance;
    }

    public void initComponent(EurekaInstanceConfig config) {
        try {
            this.config = config;
            this.instanceInfo = new EurekaConfigBasedInstanceInfoProvider(config).get();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize ApplicationInfoManager", e);
        }
    }

    public InstanceInfo getInfo() {
        return this.instanceInfo;
    }

    public void registerAppMetadata(Map<String, String> appMetadata) {
        this.instanceInfo.registerRuntimeMetadata(appMetadata);
    }

    public void setInstanceStatus(InstanceInfo.InstanceStatus status) {
        this.instanceInfo.setStatus(status);
    }

    public void refreshDataCenterInfoIfRequired() {
        String existingHostname = this.instanceInfo.getHostName();
        String newHostname = this.config.getHostName(true);
        if (newHostname != null && !newHostname.equals(existingHostname)) {
            logger.warn("The public hostname changed from : " + existingHostname + " => " + newHostname);
            InstanceInfo.Builder builder = new InstanceInfo.Builder(this.instanceInfo);
            builder.setHostName(newHostname).setDataCenterInfo(this.config.getDataCenterInfo());
            this.instanceInfo.setIsDirty(true);
        }
    }
}

