/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.inject.Inject;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.eventbus.spi.InvalidSubscriberException;
import com.netflix.eventbus.spi.Subscribe;
import com.netflix.governator.guice.lazy.LazySingleton;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class EurekaUpStatusResolver {
    private static Logger LOG = LoggerFactory.getLogger(EurekaUpStatusResolver.class);
    private volatile InstanceInfo.InstanceStatus currentStatus = InstanceInfo.InstanceStatus.UNKNOWN;
    private final EventBus eventBus;
    private final DiscoveryClient client;

    @Inject
    public EurekaUpStatusResolver(DiscoveryClient client, EventBus eventBus) {
        this.eventBus = eventBus;
        this.client = client;
    }

    @Subscribe
    public void onStatusChange(StatusChangeEvent event) {
        this.currentStatus = event.getStatus();
    }

    @PostConstruct
    public void init() {
        try {
            this.eventBus.registerSubscriber((Object)this);
            this.currentStatus = this.client.getInstanceRemoteStatus();
        }
        catch (InvalidSubscriberException e) {
            LOG.error("Error registring for discovery status change events.", (Throwable)e);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.eventBus.unregisterSubscriber((Object)this);
    }

    public InstanceInfo.InstanceStatus getStatus() {
        return this.currentStatus;
    }
}

