/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaJerseyClient {
    public static JerseyClient createJerseyClient(int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, int connectionIdleTimeout) {
        return new JerseyClient(connectionTimeout, readTimeout, maxConnectionsPerHost, maxTotalConnections, connectionIdleTimeout);
    }

    public static class JerseyClient {
        private static final int HTTP_CONNECTION_CLEANER_INTERVAL_MS = 30000;
        private ApacheHttpClient4 apacheHttpClient;
        ClientConfig jerseyClientConfig;
        private Timer eurekaConnCleaner = new Timer("Eureka-connectionCleaner", true);
        private static final Logger s_logger = LoggerFactory.getLogger(JerseyClient.class);

        public ApacheHttpClient4 getClient() {
            return this.apacheHttpClient;
        }

        public ClientConfig getClientconfig() {
            return this.jerseyClientConfig;
        }

        public JerseyClient(int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, final int connectionIdleTimeout) {
            this.jerseyClientConfig = new CustomApacheHttpClientConfig(maxConnectionsPerHost, maxTotalConnections);
            this.jerseyClientConfig.getClasses().add(DiscoveryJerseyProvider.class);
            this.apacheHttpClient = ApacheHttpClient4.create((ClientConfig)this.jerseyClientConfig);
            HttpParams params = this.apacheHttpClient.getClientHandler().getHttpClient().getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
            this.eurekaConnCleaner.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        JerseyClient.this.apacheHttpClient.getClientHandler().getHttpClient().getConnectionManager().closeIdleConnections((long)connectionIdleTimeout, TimeUnit.SECONDS);
                    }
                    catch (Throwable e) {
                        s_logger.error("Cannot clean connections", e);
                    }
                }
            }, 30000L, 30000L);
        }
    }

    private static class CustomApacheHttpClientConfig
    extends DefaultApacheHttpClient4Config {
        public CustomApacheHttpClientConfig(int maxConnectionsPerHost, int maxTotalConnections) {
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager();
            cm.setDefaultMaxPerRoute(maxConnectionsPerHost);
            cm.setMaxTotal(maxTotalConnections);
            this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
        }
    }
}

