/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.HealthCheckCallback;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.BackupRegistry;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.EurekaJerseyClient;
import com.netflix.discovery.shared.LookupService;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryClient
implements LookupService {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryClient.class);
    private static final DynamicPropertyFactory configInstance = DynamicPropertyFactory.getInstance();
    private static final String DNS_PROVIDER_URL = "dns:";
    private static final String DNS_NAMING_FACTORY = "com.sun.jndi.dns.DnsContextFactory";
    private static final String JAVA_NAMING_FACTORY_INITIAL = "java.naming.factory.initial";
    private static final String JAVA_NAMING_PROVIDER_URL = "java.naming.provider.url";
    private static final String DNS_RECORD_TYPE = "TXT";
    private static final String VALUE_DELIMITER = ",";
    private static final String COMMA_STRING = ",";
    private static final String DISCOVERY_APPID = "DISCOVERY";
    private static final String UNKNOWN = "UNKNOWN";
    private static final DirContext dirContext = DiscoveryClient.getDirContext();
    private String PREFIX = "DiscoveryClient_";
    private final Timer GET_SERVICE_URLS_DNS_TIMER = Monitors.newTimer((String)(this.PREFIX + "GetServiceUrlsFromDNS"));
    private final Timer REGISTER_TIMER = Monitors.newTimer((String)(this.PREFIX + "Register"));
    private final Timer REFRESH_TIMER = Monitors.newTimer((String)(this.PREFIX + "Refresh"));
    private final Timer REFRESH_DELTA_TIMER = Monitors.newTimer((String)(this.PREFIX + "RefreshDelta"));
    private final Timer RENEW_TIMER = Monitors.newTimer((String)(this.PREFIX + "Renew"));
    private final Timer CANCEL_TIMER = Monitors.newTimer((String)(this.PREFIX + "Cancel"));
    private final Timer FETCH_REGISTRY_TIMER = Monitors.newTimer((String)(this.PREFIX + "FetchRegistry"));
    private final Counter SERVER_RETRY_COUNTER = Monitors.newCounter((String)(this.PREFIX + "Retry"));
    private final Counter ALL_SERVER_FAILURE_COUNT = Monitors.newCounter((String)(this.PREFIX + "Failed"));
    private final Counter REREGISTER_COUNTER = Monitors.newCounter((String)(this.PREFIX + "Reregister"));
    private volatile HealthCheckCallback healthCheckCallback;
    private volatile AtomicReference<List<String>> eurekaServiceUrls = new AtomicReference();
    private volatile AtomicReference<Applications> applications = new AtomicReference();
    private InstanceInfo instanceInfo;
    private String appPathIdentifier;
    private boolean isRegisteredWithDiscovery = false;
    private String discoveryServerAMIId;
    private EurekaJerseyClient.JerseyClient discoveryJerseyClient;
    private ApacheHttpClient4 discoveryApacheClient;
    private static EurekaClientConfig clientConfig;
    private java.util.Timer cacheRefreshTimer = new java.util.Timer(this.PREFIX + "CacheRefresher", true);
    private java.util.Timer heartbeatTimer = new java.util.Timer(this.PREFIX + "Heartbeat", true);
    private java.util.Timer serviceUrlUpdaterTimer = new java.util.Timer(this.PREFIX + "ServiceURLUpdater", true);
    private java.util.Timer instanceInfoReplicatorTimer = new java.util.Timer(this.PREFIX + "InstanceInfo-Replictor", true);

    DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config) {
        try {
            clientConfig = config;
            String zone = DiscoveryClient.getZone(myInfo);
            this.eurekaServiceUrls.set(this.getDiscoveryServiceUrls(zone));
            this.serviceUrlUpdaterTimer.schedule(this.getServiceUrlUpdateTask(zone), clientConfig.getEurekaServiceUrlPollIntervalSeconds(), (long)clientConfig.getEurekaServiceUrlPollIntervalSeconds());
            this.applications.set(new Applications());
            if (myInfo != null) {
                this.instanceInfo = myInfo;
                this.appPathIdentifier = this.instanceInfo.getAppName() + "/" + this.instanceInfo.getId();
            }
            String proxyHost = clientConfig.getProxyHost();
            String proxyPort = clientConfig.getProxyPort();
            this.discoveryJerseyClient = EurekaJerseyClient.createJerseyClient(clientConfig.getEurekaServerConnectTimeoutSeconds(), clientConfig.getEurekaServerReadTimeoutSeconds(), clientConfig.getEurekaServerTotalConnectionsPerHost(), clientConfig.getEurekaServerTotalConnections(), clientConfig.getEurekaConnectionIdleTimeoutSeconds());
            this.discoveryApacheClient = this.discoveryJerseyClient.getClient();
            ClientConfig cc = this.discoveryJerseyClient.getClientconfig();
            boolean enableGZIPContentEncodingFilter = config.shouldGZipContent();
            if (enableGZIPContentEncodingFilter) {
                this.discoveryApacheClient.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
            }
            if (proxyHost != null && proxyPort != null) {
                cc.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + proxyHost + ":" + proxyPort);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize DiscoveryClient!", e);
        }
        if (!this.fetchRegistry()) {
            this.fetchRegistryFromBackup();
        }
        this.initScheduledTasks();
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register timers", e);
        }
    }

    @Override
    public Application getApplication(String appName) {
        return this.getApplications().getRegisteredApplications(appName);
    }

    @Override
    public Applications getApplications() {
        return this.applications.get();
    }

    @Override
    public List<InstanceInfo> getInstancesById(String id) {
        ArrayList<InstanceInfo> instancesList = new ArrayList<InstanceInfo>();
        for (Application app : this.getApplications().getRegisteredApplications()) {
            InstanceInfo instanceInfo = app.getByInstanceId(id);
            if (instanceInfo == null) continue;
            instancesList.add(instanceInfo);
        }
        return instancesList;
    }

    public void registerHealthCheckCallback(HealthCheckCallback callback) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a listener for instance info since it is null!");
        }
        if (callback != null) {
            this.healthCheckCallback = callback;
        }
    }

    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure) {
        if (vipAddress == null) {
            throw new IllegalArgumentException("Supplied VIP Address cannot be null");
        }
        if (!secure) {
            return this.applications.get().getInstancesByVirtualHostName(vipAddress);
        }
        return this.applications.get().getInstancesBySecureVirtualHostName(vipAddress);
    }

    public List<InstanceInfo> getInstancesByVipAddressAndAppName(String vipAddress, String appName, boolean secure) {
        List<InstanceInfo> result = new ArrayList<InstanceInfo>();
        if (vipAddress == null && appName == null) {
            throw new IllegalArgumentException("Supplied VIP Address and application name cannot both be null");
        }
        if (vipAddress != null && appName == null) {
            return this.getInstancesByVipAddress(vipAddress, secure);
        }
        if (vipAddress == null && appName != null) {
            Application application = this.getApplication(appName);
            if (application != null) {
                result = application.getInstances();
            }
            return result;
        }
        for (Application app : this.getApplications().getRegisteredApplications()) {
            block1: for (InstanceInfo instance : app.getInstances()) {
                String[] instanceVipAddresses;
                String instanceVipAddress = secure ? instance.getSecureVipAddress() : instance.getVIPAddress();
                if (instanceVipAddress == null) continue;
                for (String vipAddressFromList : instanceVipAddresses = instanceVipAddress.split(",")) {
                    if (!vipAddress.equalsIgnoreCase(vipAddressFromList.trim()) || !appName.equalsIgnoreCase(instance.getAppName())) continue;
                    result.add(instance);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public InstanceInfo getNextServerFromEureka(String virtualHostname, boolean secure) {
        List<InstanceInfo> instanceInfoList = this.getInstancesByVipAddress(virtualHostname, secure);
        if (instanceInfoList == null || instanceInfoList.isEmpty()) {
            throw new RuntimeException("No matches for the virtual host name :" + virtualHostname);
        }
        Applications apps = this.applications.get();
        int index = (int)(apps.getNextIndex(virtualHostname.toUpperCase(), secure).incrementAndGet() % (long)instanceInfoList.size());
        InstanceInfo instanceInfo = instanceInfoList.get(index);
        return instanceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Applications getApplications(String serviceUrl) {
        ClientResponse response = null;
        Applications apps = null;
        try {
            response = this.getUrl(serviceUrl + "apps/");
            apps = (Applications)response.getEntity(Applications.class);
            logger.debug(this.PREFIX + this.appPathIdentifier + " -  refresh status: " + response.getStatus());
            Applications applications = apps;
            return applications;
        }
        catch (Exception e) {
            logger.error(this.PREFIX + this.appPathIdentifier + " - was unable to refresh it's cache! status = " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return apps;
    }

    private boolean shouldRegister(InstanceInfo myInfo) {
        boolean shouldRegister = clientConfig.shouldRegisterWithEureka();
        if (!shouldRegister) {
            return false;
        }
        if (myInfo != null && myInfo.getDataCenterInfo().equals((Object)DataCenterInfo.Name.Amazon)) {
            return true;
        }
        return shouldRegister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register() {
        logger.info(this.PREFIX + this.appPathIdentifier + ": registering service...");
        ClientResponse response = null;
        try {
            response = this.makeRemoteCall(Action.Register);
            this.isRegisteredWithDiscovery = true;
            logger.info(this.PREFIX + this.appPathIdentifier + " - registration status: " + (response != null ? Integer.valueOf(response.getStatus()) : "not sent"));
        }
        catch (Throwable e) {
            logger.error(this.PREFIX + this.appPathIdentifier + " - registration failed" + e.getMessage(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public static List<String> getEurekaServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        int currentOffset;
        ArrayList<String> orderedUrls = new ArrayList<String>();
        String region = DiscoveryClient.getRegion();
        Object[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        if (availZones == null || availZones.length == 0) {
            availZones = new String[]{"default"};
        }
        logger.debug("The availability zone for the given region {} are %s", (Object)region, (Object)Arrays.toString(availZones));
        int myZoneOffset = DiscoveryClient.getZoneOffset(instanceZone, preferSameZone, (String[])availZones);
        List<String> serviceUrls = clientConfig.getEurekaServerServiceUrls((String)availZones[myZoneOffset]);
        if (serviceUrls != null) {
            orderedUrls.addAll(serviceUrls);
        }
        int n = currentOffset = myZoneOffset == availZones.length - 1 ? 0 : myZoneOffset + 1;
        while (currentOffset != myZoneOffset) {
            serviceUrls = clientConfig.getEurekaServerServiceUrls((String)availZones[currentOffset]);
            if (serviceUrls != null) {
                orderedUrls.addAll(serviceUrls);
            }
            if (currentOffset == availZones.length - 1) {
                currentOffset = 0;
                continue;
            }
            ++currentOffset;
        }
        if (orderedUrls.size() < 1) {
            throw new IllegalArgumentException("DiscoveryClient: invalid serviceUrl specified!");
        }
        return orderedUrls;
    }

    public void shutdown() {
        if (this.instanceInfo != null) {
            this.instanceInfo.setStatus(InstanceInfo.InstanceStatus.DOWN);
            this.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        ClientResponse response = null;
        try {
            response = this.makeRemoteCall(Action.Cancel);
            logger.info(this.PREFIX + this.appPathIdentifier + " - deregister  status: " + (response != null ? Integer.valueOf(response.getStatus()) : "not registered"));
        }
        catch (Throwable e) {
            logger.error(this.PREFIX + this.appPathIdentifier + " - de-registration failed" + e.getMessage(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchRegistry() {
        ClientResponse response;
        block11: {
            response = null;
            Stopwatch tracer = this.FETCH_REGISTRY_TIMER.start();
            try {
                if (clientConfig.shouldDisableDelta() || this.getApplications() == null || this.getApplications().getRegisteredApplications().size() == 0 || this.getApplications().getVersion() == -1L) {
                    logger.info("Disable delta property : {}", (Object)clientConfig.shouldDisableDelta());
                    logger.info("Application is null : {}", (Object)(this.getApplications() == null ? 1 : 0));
                    logger.info("Registered Applications size is zero : {}", (Object)(this.getApplications().getRegisteredApplications().size() == 0 ? 1 : 0));
                    logger.info("Application version is -1: {}", (Object)(this.getApplications().getVersion() == -1L ? 1 : 0));
                    response = this.getAndStoreFullRegistry();
                } else {
                    Applications delta = null;
                    response = this.makeRemoteCall(Action.Refresh_Delta);
                    if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                        delta = (Applications)response.getEntity(Applications.class);
                    }
                    if (delta == null) {
                        logger.warn("The server does not allow the delta revision to be applied because it is not safe. Hence got the full registry.");
                        this.closeResponse(response);
                        response = this.getAndStoreFullRegistry();
                    } else {
                        this.updateDelta(delta);
                        String reconcileHashCode = this.getApplications().getReconcileHashCode();
                        if (!reconcileHashCode.equals(delta.getAppsHashCode()) || clientConfig.shouldLogDeltaDiff()) {
                            response = this.reconcileAndLogDifference(response, delta, reconcileHashCode);
                        }
                    }
                    this.logTotalInstances();
                }
                logger.debug(this.PREFIX + this.appPathIdentifier + " -  refresh status: " + response.getStatus());
                if (tracer == null) break block11;
            }
            catch (Throwable e) {
                boolean bl;
                block12: {
                    try {
                        logger.error(this.PREFIX + this.appPathIdentifier + " - was unable to refresh it's cache! status = " + e.getMessage(), e);
                        bl = false;
                        if (tracer == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (tracer != null) {
                            tracer.stop();
                        }
                        this.closeResponse(response);
                        throw throwable;
                    }
                    tracer.stop();
                }
                this.closeResponse(response);
                return bl;
            }
            tracer.stop();
        }
        this.closeResponse(response);
        return true;
    }

    private ClientResponse getAndStoreFullRegistry() throws Throwable {
        ClientResponse response = this.makeRemoteCall(Action.Refresh);
        logger.info("Getting all instance registry info from the eureka server");
        Applications apps = (Applications)response.getEntity(Applications.class);
        this.applications.set(this.filterAndShuffle(apps));
        logger.info("The response status is {}", (Object)response.getStatus());
        return response;
    }

    private void logTotalInstances() {
        int totInstances = 0;
        for (Application application : this.getApplications().getRegisteredApplications()) {
            totInstances += application.getInstances().size();
        }
        logger.debug("The total number of instances in the client now is {}", (Object)totInstances);
    }

    private ClientResponse reconcileAndLogDifference(ClientResponse response, Applications delta, String reconcileHashCode) throws Throwable {
        logger.warn("The Reconcile hashcodes do not match, client : {}, server : {}. Getting the full registry", (Object)reconcileHashCode, (Object)delta.getAppsHashCode());
        this.closeResponse(response);
        response = this.makeRemoteCall(Action.Refresh);
        Applications serverApps = (Applications)response.getEntity(Applications.class);
        Map<String, List<String>> reconcileDiffMap = this.getApplications().getReconcileMapDiff(serverApps);
        String reconcileString = "";
        for (Map.Entry<String, List<String>> mapEntry : reconcileDiffMap.entrySet()) {
            reconcileString = reconcileString + mapEntry.getKey() + ": ";
            for (String displayString : mapEntry.getValue()) {
                reconcileString = reconcileString + displayString;
            }
            reconcileString = reconcileString + "\n";
        }
        logger.warn("The reconcile string is {}", (Object)reconcileString);
        this.applications.set(this.filterAndShuffle(serverApps));
        this.getApplications().setVersion(delta.getVersion());
        logger.warn("The Reconcile hashcodes after complete sync up, client : {}, server : {}.", (Object)this.getApplications().getReconcileHashCode(), (Object)delta.getAppsHashCode());
        return response;
    }

    private void updateDelta(Applications delta) {
        int deltaCount = 0;
        for (Application app : delta.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                Application existingApp;
                ++deltaCount;
                if (InstanceInfo.ActionType.ADDED.equals((Object)instance.getActionType())) {
                    existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        this.getApplications().addApplication(app);
                    }
                    logger.debug("Added instance {} to the existing apps ", (Object)instance.getId());
                    this.getApplications().getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (InstanceInfo.ActionType.MODIFIED.equals((Object)instance.getActionType())) {
                    existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        this.getApplications().addApplication(app);
                    }
                    logger.debug("Modified instance {} to the existing apps ", (Object)instance.getId());
                    this.getApplications().getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (!InstanceInfo.ActionType.DELETED.equals((Object)instance.getActionType())) continue;
                existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                if (existingApp == null) {
                    this.getApplications().addApplication(app);
                }
                logger.debug("Deleted instance {} to the existing apps ", (Object)instance.getId());
                this.getApplications().getRegisteredApplications(instance.getAppName()).removeInstance(instance);
            }
        }
        logger.debug("The total number of instances fetched by the delta processor : {}", (Object)deltaCount);
        this.getApplications().setVersion(delta.getVersion());
        this.getApplications().shuffleInstances(clientConfig.shouldFilterOnlyUpInstances());
    }

    private ClientResponse makeRemoteCall(Action action) throws Throwable {
        return this.makeRemoteCall(action, 0);
    }

    private ClientResponse makeRemoteCall(Action action, int serviceUrlIndex) throws Throwable {
        String urlPath = null;
        Stopwatch tracer = null;
        String serviceUrl = this.eurekaServiceUrls.get().get(serviceUrlIndex);
        ClientResponse response = null;
        logger.debug("Discovery Client talking to the server {}", (Object)serviceUrl);
        try {
            if (UNKNOWN.equals(this.instanceInfo.getAppName()) && !Action.Refresh.equals((Object)action) && !Action.Refresh_Delta.equals((Object)action)) {
                ClientResponse clientResponse = null;
                return clientResponse;
            }
            WebResource r = this.discoveryApacheClient.resource(serviceUrl);
            switch (action) {
                case Renew: {
                    tracer = this.RENEW_TIMER.start();
                    urlPath = "apps/" + this.appPathIdentifier;
                    response = (ClientResponse)r.path(urlPath).queryParam("status", this.instanceInfo.getStatus().toString()).queryParam("lastDirtyTimestamp", this.instanceInfo.getLastDirtyTimestamp().toString()).put(ClientResponse.class);
                    break;
                }
                case Refresh: {
                    tracer = this.REFRESH_TIMER.start();
                    urlPath = "apps/";
                    response = this.getUrl(serviceUrl + urlPath);
                    break;
                }
                case Refresh_Delta: {
                    tracer = this.REFRESH_DELTA_TIMER.start();
                    urlPath = "apps/delta";
                    response = this.getUrl(serviceUrl + urlPath);
                    break;
                }
                case Register: {
                    tracer = this.REGISTER_TIMER.start();
                    urlPath = "apps/" + this.instanceInfo.getAppName();
                    response = (ClientResponse)r.path(urlPath).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)this.instanceInfo);
                    break;
                }
                case Cancel: {
                    tracer = this.CANCEL_TIMER.start();
                    urlPath = "apps/" + this.appPathIdentifier;
                    response = (ClientResponse)r.path(urlPath).delete(ClientResponse.class);
                    if (this.isRegisteredWithDiscovery || response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) break;
                    ClientResponse clientResponse = response;
                    return clientResponse;
                }
            }
            if (this.isOk(action, response.getStatus())) {
                ClientResponse clientResponse = response;
                return clientResponse;
            }
            try {
                logger.warn("Action: " + (Object)((Object)action) + "  => returned status of " + response.getStatus() + " from " + serviceUrl + urlPath);
                throw new RuntimeException("Bad status: " + response.getStatus());
            }
            catch (Throwable t) {
                this.closeResponse(response);
                String msg = "Can't get a response from " + serviceUrl + urlPath;
                if (this.eurekaServiceUrls.get().size() > ++serviceUrlIndex) {
                    logger.warn(msg, t);
                    logger.warn("Trying backup: " + this.eurekaServiceUrls.get().get(serviceUrlIndex));
                    this.SERVER_RETRY_COUNTER.increment();
                    ClientResponse clientResponse = this.makeRemoteCall(action, serviceUrlIndex);
                    return clientResponse;
                }
                this.ALL_SERVER_FAILURE_COUNT.increment();
                logger.error(msg + "\nCan't contact any eureka nodes - possibly a security group issue?", t);
                throw t;
            }
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    private void closeResponse(ClientResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Throwable th) {
                logger.error("Cannot release response resource :", th);
            }
        }
    }

    private void initScheduledTasks() {
        this.cacheRefreshTimer.schedule((TimerTask)new CacheRefreshThread(), clientConfig.getRegistryFetchIntervalSeconds() * 1000, (long)(clientConfig.getRegistryFetchIntervalSeconds() * 1000));
        if (this.shouldRegister(this.instanceInfo)) {
            logger.info("Starting heartbeat executor: renew interval is: " + this.instanceInfo.getLeaseInfo().getRenewalIntervalInSecs());
            this.heartbeatTimer.schedule((TimerTask)new HeartbeatThread(), this.instanceInfo.getLeaseInfo().getRenewalIntervalInSecs() * 1000, (long)(this.instanceInfo.getLeaseInfo().getRenewalIntervalInSecs() * 1000));
            this.instanceInfoReplicatorTimer.schedule((TimerTask)new InstanceInfoReplicator(), 10000 + clientConfig.getInstanceInfoReplicationIntervalSeconds() * 1000, (long)(clientConfig.getInstanceInfoReplicationIntervalSeconds() * 1000));
        }
    }

    public List<String> getServiceUrlsFromDNS(String instanceZone, boolean preferSameZone) {
        Stopwatch t = this.GET_SERVICE_URLS_DNS_TIMER.start();
        String region = DiscoveryClient.getRegion();
        Map<String, List<String>> zoneDnsNamesMap = DiscoveryClient.getZoneBasedDiscoveryUrlsFromRegion(region);
        Set<String> availableZones = zoneDnsNamesMap.keySet();
        LinkedList<String> zones = new LinkedList<String>(availableZones);
        int zoneIndex = 0;
        boolean zoneFound = false;
        for (String zone : zones) {
            logger.debug("Checking if the instance zone {} is the same as the zone from DNS {}", (Object)instanceZone, (Object)zone);
            if (preferSameZone) {
                if (instanceZone.equalsIgnoreCase(zone)) {
                    zoneFound = true;
                }
            } else if (!instanceZone.equalsIgnoreCase(zone)) {
                zoneFound = true;
            }
            if (zoneFound) {
                Object[] args = new Object[]{zones, instanceZone, zoneIndex};
                logger.debug("The zone index from the list {} that matches the instance zone {} is {}", args);
                break;
            }
            ++zoneIndex;
        }
        for (int i = 0; i < zoneIndex; ++i) {
            String zone;
            zone = (String)zones.remove(0);
            zones.add(zone);
        }
        ArrayList<String> serviceUrls = new ArrayList<String>();
        for (String zone : zones) {
            for (String zoneCname : zoneDnsNamesMap.get(zone)) {
                for (String ec2Url : DiscoveryClient.getEC2DiscoveryUrlsFromZone(zoneCname, DiscoveryUrlType.CNAME)) {
                    String serviceUrl = "http://" + ec2Url + ":" + clientConfig.getEurekaServerPort() + "/" + clientConfig.getEurekaServerURLContext() + "/";
                    logger.debug("The EC2 url is {}", (Object)serviceUrl);
                    serviceUrls.add(serviceUrl);
                }
            }
        }
        t.stop();
        return serviceUrls;
    }

    public List<String> getDiscoveryServiceUrls(String zone) {
        boolean shouldUseDns = clientConfig.shouldUseDnsForFetchingServiceUrls();
        if (shouldUseDns) {
            return this.getServiceUrlsFromDNS(zone, clientConfig.shouldPreferSameZoneEureka());
        }
        return DiscoveryClient.getEurekaServiceUrlsFromConfig(zone, clientConfig.shouldPreferSameZoneEureka());
    }

    public static String getZone(InstanceInfo myInfo) {
        String awsInstanceZone;
        String instanceZone;
        String[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        String string = instanceZone = availZones == null || availZones.length == 0 ? "default" : availZones[0];
        if (myInfo != null && myInfo.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon && (awsInstanceZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone)) != null) {
            instanceZone = awsInstanceZone;
        }
        return instanceZone;
    }

    public static String getRegion() {
        String region = clientConfig.getRegion();
        if (region == null) {
            region = "default";
        }
        region = region.trim().toLowerCase();
        return region;
    }

    private static Map<String, List<String>> getZoneBasedDiscoveryUrlsFromRegion(String region) {
        String discoveryDnsName = null;
        try {
            discoveryDnsName = "txt." + region + "." + clientConfig.getEurekaServerDNSName();
            logger.debug("The region url to be looked up is {} :", (Object)discoveryDnsName);
            TreeSet<String> zoneCnamesForRegion = new TreeSet<String>(DiscoveryClient.getCnamesFromDirContext(dirContext, discoveryDnsName));
            TreeMap<String, List<String>> zoneCnameMapForRegion = new TreeMap<String, List<String>>();
            for (String zoneCname : zoneCnamesForRegion) {
                String zone = null;
                if (DiscoveryClient.isEC2Url(zoneCname)) {
                    throw new RuntimeException("Cannot find the right DNS entry for " + discoveryDnsName + ". " + "Expected mapping of the format <aws_zone>.<domain_name>");
                }
                String[] cnameTokens = zoneCname.split("\\.");
                zone = cnameTokens[0];
                logger.debug("The zoneName mapped to region {} is {}", (Object)region, (Object)zone);
                ArrayList<String> zoneCnamesSet = (ArrayList<String>)zoneCnameMapForRegion.get(zone);
                if (zoneCnamesSet == null) {
                    zoneCnamesSet = new ArrayList<String>();
                    zoneCnameMapForRegion.put(zone, zoneCnamesSet);
                }
                zoneCnamesSet.add(zoneCname);
            }
            return zoneCnameMapForRegion;
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get cnames bound to the region:" + discoveryDnsName, e);
        }
    }

    private static boolean isEC2Url(String zoneCname) {
        return zoneCname.startsWith("ec2");
    }

    public static Set<String> getEC2DiscoveryUrlsFromZone(String dnsName, DiscoveryUrlType type) {
        TreeSet<String> eipsForZone = null;
        try {
            dnsName = "txt." + dnsName;
            logger.debug("The zone url to be looked up is {} :", (Object)dnsName);
            Set<String> ec2UrlsForZone = DiscoveryClient.getCnamesFromDirContext(dirContext, dnsName);
            for (String ec2Url : ec2UrlsForZone) {
                logger.debug("The eureka url for the dns name {} is {}", (Object)dnsName, (Object)ec2Url);
                ec2UrlsForZone.add(ec2Url);
            }
            if (DiscoveryUrlType.CNAME.equals((Object)type)) {
                return ec2UrlsForZone;
            }
            eipsForZone = new TreeSet<String>();
            for (String cname : ec2UrlsForZone) {
                String[] tokens = cname.split("\\.");
                String ec2HostName = tokens[0];
                String[] ips = ec2HostName.split("-");
                StringBuffer eipBuffer = new StringBuffer();
                for (int ipCtr = 1; ipCtr < 5; ++ipCtr) {
                    eipBuffer.append(ips[ipCtr]);
                    if (ipCtr >= 4) continue;
                    eipBuffer.append(".");
                }
                eipsForZone.add(eipBuffer.toString());
            }
            logger.debug("The EIPS for {} is {} :", (Object)dnsName, eipsForZone);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get cnames bound to the region:" + dnsName, e);
        }
        return eipsForZone;
    }

    private static int getZoneOffset(String myZone, boolean preferSameZone, String[] availZones) {
        for (int i = 0; i < availZones.length; ++i) {
            if (myZone == null || availZones[i].equalsIgnoreCase(myZone.trim()) != preferSameZone) continue;
            return i;
        }
        logger.error("DISCOVERY: invalid zone - " + myZone + " defaulting to " + availZones[0]);
        return 0;
    }

    private boolean isOk(Action action, int httpStatus) {
        if (httpStatus >= 200 && httpStatus < 300) {
            return true;
        }
        if (Action.Renew == action && httpStatus == 404) {
            return true;
        }
        return Action.Refresh_Delta == action && (httpStatus == 403 || httpStatus == 404);
    }

    private InstanceInfo getCoordinatingServer() {
        Application app = this.getApplication(DISCOVERY_APPID);
        List<InstanceInfo> discoveryInstances = null;
        InstanceInfo instanceToReturn = null;
        if (app != null) {
            discoveryInstances = app.getInstances();
        }
        if (discoveryInstances != null) {
            for (InstanceInfo instance : discoveryInstances) {
                if (instance == null || !instance.isCoordinatingDiscoveryServer().booleanValue()) continue;
                instanceToReturn = instance;
                break;
            }
        }
        return instanceToReturn;
    }

    private ClientResponse getUrl(String fullServiceUrl) {
        ClientResponse cr = (ClientResponse)this.discoveryApacheClient.resource(fullServiceUrl).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
        return cr;
    }

    private boolean isHealthCheckEnabled() {
        return this.healthCheckCallback != null && InstanceInfo.InstanceStatus.STARTING != this.instanceInfo.getStatus() && InstanceInfo.InstanceStatus.OUT_OF_SERVICE != this.instanceInfo.getStatus();
    }

    private static DirContext getDirContext() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put(JAVA_NAMING_FACTORY_INITIAL, DNS_NAMING_FACTORY);
        env.put(JAVA_NAMING_PROVIDER_URL, DNS_PROVIDER_URL);
        InitialDirContext dirContext = null;
        try {
            dirContext = new InitialDirContext(env);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get dir context for some reason", e);
        }
        return dirContext;
    }

    private static Set<String> getCnamesFromDirContext(DirContext dirContext, String discoveryDnsName) throws Throwable {
        String[] cnames;
        Attributes attrs = dirContext.getAttributes(discoveryDnsName, new String[]{DNS_RECORD_TYPE});
        Attribute attr = attrs.get(DNS_RECORD_TYPE);
        String txtRecord = null;
        if (attr != null) {
            txtRecord = attr.get().toString();
        }
        TreeSet<String> cnamesSet = new TreeSet<String>();
        if (txtRecord == null || "".equals(txtRecord.trim())) {
            return cnamesSet;
        }
        for (String cname : cnames = txtRecord.split(" ")) {
            cnamesSet.add(cname);
        }
        return cnamesSet;
    }

    private static String[] getInstanceVipAddresses(InstanceInfo instanceInfo, boolean isSecure) {
        String vipAddresses = isSecure ? instanceInfo.getSecureVipAddress() : instanceInfo.getVIPAddress();
        if (vipAddresses == null) {
            return new String[0];
        }
        return vipAddresses.split(",");
    }

    private void fetchRegistryFromBackup() {
        String backupRegistry = clientConfig.getBackupRegistryImpl();
        if (backupRegistry != null) {
            try {
                BackupRegistry backupRegistryInstance = (BackupRegistry)Class.forName(backupRegistry).newInstance();
                Applications apps = backupRegistryInstance.fetchRegistry();
                if (apps != null) {
                    this.applications.set(this.filterAndShuffle(apps));
                    this.logTotalInstances();
                    logger.info("Fetched registry successfully from the backup");
                }
            }
            catch (Throwable e) {
                logger.warn("Cannot fetch applications from apps although backup registry was specified", e);
            }
        }
    }

    private TimerTask getServiceUrlUpdateTask(final String zone) {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    List<String> serviceUrlList = DiscoveryClient.this.getDiscoveryServiceUrls(zone);
                    if (serviceUrlList.isEmpty()) {
                        logger.warn("The service url list is empty");
                        return;
                    }
                    if (!((Object)serviceUrlList).equals(DiscoveryClient.this.eurekaServiceUrls.get())) {
                        logger.debug("Updating the serviceUrls as they seem to have changed from {} to {} ", (Object)Arrays.toString(((List)DiscoveryClient.this.eurekaServiceUrls.get()).toArray()), (Object)Arrays.toString(serviceUrlList.toArray()));
                        DiscoveryClient.this.eurekaServiceUrls.set(serviceUrlList);
                    }
                }
                catch (Throwable e) {
                    logger.error("Cannot get the eureka service urls :", e);
                }
            }
        };
    }

    private Applications filterAndShuffle(Applications apps) {
        if (apps != null) {
            apps.shuffleInstances(clientConfig.shouldFilterOnlyUpInstances());
        }
        return apps;
    }

    class CacheRefreshThread
    extends TimerTask {
        CacheRefreshThread() {
        }

        @Override
        public void run() {
            try {
                DiscoveryClient.this.fetchRegistry();
            }
            catch (Throwable th) {
                logger.error("Cannot fetch registry from server", th);
            }
        }
    }

    private class InstanceInfoReplicator
    extends TimerTask {
        private InstanceInfoReplicator() {
        }

        @Override
        public void run() {
            try {
                ApplicationInfoManager.getInstance().refreshDataCenterInfoIfRequired();
                InstanceInfo discoveryServer = DiscoveryClient.this.getCoordinatingServer();
                if (discoveryServer != null && DataCenterInfo.Name.Amazon.equals(discoveryServer.getDataCenterInfo())) {
                    String amiId = ((AmazonInfo)discoveryServer.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.amiId);
                    if (DiscoveryClient.this.discoveryServerAMIId == null) {
                        DiscoveryClient.this.discoveryServerAMIId = amiId;
                    } else if (!DiscoveryClient.this.discoveryServerAMIId.equals(amiId)) {
                        logger.info("The eureka AMI ID changed from " + DiscoveryClient.this.discoveryServerAMIId + " to " + amiId + ". Pushing the appinfo to eureka");
                        DiscoveryClient.this.instanceInfo.setIsDirty(true);
                        DiscoveryClient.this.discoveryServerAMIId = amiId;
                    }
                }
                if (DiscoveryClient.this.isHealthCheckEnabled()) {
                    boolean isHealthy = DiscoveryClient.this.healthCheckCallback.isHealthy();
                    DiscoveryClient.this.instanceInfo.setStatus(isHealthy ? InstanceInfo.InstanceStatus.UP : InstanceInfo.InstanceStatus.DOWN);
                }
                if (DiscoveryClient.this.instanceInfo.isDirty()) {
                    logger.info(DiscoveryClient.this.PREFIX + DiscoveryClient.this.appPathIdentifier + " - retransmit instance info with status " + DiscoveryClient.this.instanceInfo.getStatus().toString());
                    DiscoveryClient.this.register();
                    DiscoveryClient.this.instanceInfo.setIsDirty(false);
                }
            }
            catch (Throwable t) {
                logger.error("There was a problem with the instance info replicator :", t);
            }
        }
    }

    private class HeartbeatThread
    extends TimerTask {
        private HeartbeatThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClientResponse response = null;
            try {
                response = DiscoveryClient.this.makeRemoteCall(Action.Renew);
                logger.debug(DiscoveryClient.this.PREFIX + DiscoveryClient.this.appPathIdentifier + " - Heartbeat status: " + (response != null ? Integer.valueOf(response.getStatus()) : "not sent"));
                if (response == null) {
                    return;
                }
                if (response.getStatus() == 404) {
                    DiscoveryClient.this.REREGISTER_COUNTER.increment();
                    logger.info(DiscoveryClient.this.PREFIX + DiscoveryClient.this.appPathIdentifier + " - Re-registering " + "apps/" + DiscoveryClient.this.instanceInfo.getAppName());
                    DiscoveryClient.this.register();
                }
            }
            catch (Throwable e) {
                logger.error(DiscoveryClient.this.PREFIX + DiscoveryClient.this.appPathIdentifier + " - was unable to send heartbeat!", e);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    public static enum DiscoveryUrlType {
        CNAME,
        A;

    }

    private static enum Action {
        Register,
        Cancel,
        Renew,
        Refresh,
        Refresh_Delta;

    }
}

