/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.github.vmg.protogen.annotations.ProtoField;
import com.github.vmg.protogen.annotations.ProtoMessage;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.SubWorkflowParams;
import com.netflix.conductor.common.metadata.workflow.TaskType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.PositiveOrZero;

@ProtoMessage
public class WorkflowTask {
    @ProtoField(id=1)
    @NotEmpty(message="WorkflowTask name cannot be empty or null")
    private @NotEmpty(message="WorkflowTask name cannot be empty or null") String name;
    @ProtoField(id=2)
    @NotEmpty(message="WorkflowTask taskReferenceName name cannot be empty or null")
    private @NotEmpty(message="WorkflowTask taskReferenceName name cannot be empty or null") String taskReferenceName;
    @ProtoField(id=3)
    private String description;
    @ProtoField(id=4)
    private Map<String, Object> inputParameters = new HashMap<String, Object>();
    @ProtoField(id=5)
    private String type = TaskType.SIMPLE.name();
    @ProtoField(id=6)
    private String dynamicTaskNameParam;
    @ProtoField(id=7)
    private String caseValueParam;
    @ProtoField(id=8)
    private String caseExpression;
    @ProtoField(id=22)
    private String scriptExpression;
    @ProtoField(id=9)
    private Map<String, @Valid List<@Valid WorkflowTask>> decisionCases = new LinkedHashMap<String, List<WorkflowTask>>();
    @Deprecated
    private String dynamicForkJoinTasksParam;
    @ProtoField(id=10)
    private String dynamicForkTasksParam;
    @ProtoField(id=11)
    private String dynamicForkTasksInputParamName;
    @ProtoField(id=12)
    private List<@Valid WorkflowTask> defaultCase = new LinkedList<WorkflowTask>();
    @ProtoField(id=13)
    private List<@Valid List<@Valid WorkflowTask>> forkTasks = new LinkedList<List<WorkflowTask>>();
    @ProtoField(id=14)
    @PositiveOrZero
    private int startDelay;
    @ProtoField(id=15)
    @Valid
    private SubWorkflowParams subWorkflowParam;
    @ProtoField(id=16)
    private List<String> joinOn = new LinkedList<String>();
    @ProtoField(id=17)
    private String sink;
    @ProtoField(id=18)
    private boolean optional = false;
    @ProtoField(id=19)
    private TaskDef taskDefinition;
    @ProtoField(id=20)
    private Boolean rateLimited;
    @ProtoField(id=21)
    private List<String> defaultExclusiveJoinTask = new LinkedList<String>();
    @ProtoField(id=23)
    private Boolean asyncComplete = false;
    @ProtoField(id=24)
    private String loopCondition;
    @ProtoField(id=25)
    private List<WorkflowTask> loopOver = new LinkedList<WorkflowTask>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskReferenceName() {
        return this.taskReferenceName;
    }

    public void setTaskReferenceName(String taskReferenceName) {
        this.taskReferenceName = taskReferenceName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public String getType() {
        return this.type;
    }

    public void setWorkflowTaskType(TaskType type) {
        this.type = type.name();
    }

    public void setType(@NotEmpty(message="WorkTask type cannot be null or empty") @NotEmpty(message="WorkTask type cannot be null or empty") String type) {
        this.type = type;
    }

    public Map<String, List<WorkflowTask>> getDecisionCases() {
        return this.decisionCases;
    }

    public void setDecisionCases(Map<String, List<WorkflowTask>> decisionCases) {
        this.decisionCases = decisionCases;
    }

    public List<WorkflowTask> getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(List<WorkflowTask> defaultCase) {
        this.defaultCase = defaultCase;
    }

    public List<List<WorkflowTask>> getForkTasks() {
        return this.forkTasks;
    }

    public void setForkTasks(List<List<WorkflowTask>> forkTasks) {
        this.forkTasks = forkTasks;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public String getDynamicTaskNameParam() {
        return this.dynamicTaskNameParam;
    }

    public void setDynamicTaskNameParam(String dynamicTaskNameParam) {
        this.dynamicTaskNameParam = dynamicTaskNameParam;
    }

    public String getCaseValueParam() {
        return this.caseValueParam;
    }

    @Deprecated
    public String getDynamicForkJoinTasksParam() {
        return this.dynamicForkJoinTasksParam;
    }

    @Deprecated
    public void setDynamicForkJoinTasksParam(String dynamicForkJoinTasksParam) {
        this.dynamicForkJoinTasksParam = dynamicForkJoinTasksParam;
    }

    public String getDynamicForkTasksParam() {
        return this.dynamicForkTasksParam;
    }

    public void setDynamicForkTasksParam(String dynamicForkTasksParam) {
        this.dynamicForkTasksParam = dynamicForkTasksParam;
    }

    public String getDynamicForkTasksInputParamName() {
        return this.dynamicForkTasksInputParamName;
    }

    public void setDynamicForkTasksInputParamName(String dynamicForkTasksInputParamName) {
        this.dynamicForkTasksInputParamName = dynamicForkTasksInputParamName;
    }

    public void setCaseValueParam(String caseValueParam) {
        this.caseValueParam = caseValueParam;
    }

    public String getCaseExpression() {
        return this.caseExpression;
    }

    public void setCaseExpression(String caseExpression) {
        this.caseExpression = caseExpression;
    }

    public String getScriptExpression() {
        return this.scriptExpression;
    }

    public void setScriptExpression(String expression) {
        this.scriptExpression = expression;
    }

    public SubWorkflowParams getSubWorkflowParam() {
        return this.subWorkflowParam;
    }

    public void setSubWorkflowParam(SubWorkflowParams subWorkflow) {
        this.subWorkflowParam = subWorkflow;
    }

    public List<String> getJoinOn() {
        return this.joinOn;
    }

    public void setJoinOn(List<String> joinOn) {
        this.joinOn = joinOn;
    }

    public String getLoopCondition() {
        return this.loopCondition;
    }

    public void setLoopCondition(String loopCondition) {
        this.loopCondition = loopCondition;
    }

    public List<WorkflowTask> getLoopOver() {
        return this.loopOver;
    }

    public void setLoopOver(List<WorkflowTask> loopOver) {
        this.loopOver = loopOver;
    }

    public String getSink() {
        return this.sink;
    }

    public void setSink(String sink) {
        this.sink = sink;
    }

    public Boolean isAsyncComplete() {
        return this.asyncComplete;
    }

    public void setAsyncComplete(Boolean asyncComplete) {
        this.asyncComplete = asyncComplete;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public TaskDef getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(TaskDef taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Boolean getRateLimited() {
        return this.rateLimited;
    }

    public void setRateLimited(Boolean rateLimited) {
        this.rateLimited = rateLimited;
    }

    public Boolean isRateLimited() {
        return this.rateLimited != null && this.rateLimited != false;
    }

    public List<String> getDefaultExclusiveJoinTask() {
        return this.defaultExclusiveJoinTask;
    }

    public void setDefaultExclusiveJoinTask(List<String> defaultExclusiveJoinTask) {
        this.defaultExclusiveJoinTask = defaultExclusiveJoinTask;
    }

    private Collection<List<WorkflowTask>> children() {
        LinkedList<List<WorkflowTask>> workflowTaskLists = new LinkedList<List<WorkflowTask>>();
        TaskType taskType = TaskType.USER_DEFINED;
        if (TaskType.isSystemTask(this.type)) {
            taskType = TaskType.valueOf(this.type);
        }
        switch (taskType) {
            case DECISION: {
                workflowTaskLists.addAll(this.decisionCases.values());
                workflowTaskLists.add(this.defaultCase);
                break;
            }
            case FORK_JOIN: {
                workflowTaskLists.addAll(this.forkTasks);
                break;
            }
            case DO_WHILE: {
                workflowTaskLists.add(this.loopOver);
                break;
            }
        }
        return workflowTaskLists;
    }

    public List<WorkflowTask> collectTasks() {
        LinkedList<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
        tasks.add(this);
        for (List<WorkflowTask> workflowTaskList : this.children()) {
            for (WorkflowTask workflowTask : workflowTaskList) {
                tasks.addAll(workflowTask.collectTasks());
            }
        }
        return tasks;
    }

    public WorkflowTask next(String taskReferenceName, WorkflowTask parent) {
        TaskType taskType = TaskType.USER_DEFINED;
        if (TaskType.isSystemTask(this.type)) {
            taskType = TaskType.valueOf(this.type);
        }
        switch (taskType) {
            case DECISION: 
            case DO_WHILE: {
                for (List<WorkflowTask> workflowTasks : this.children()) {
                    WorkflowTask task;
                    Iterator<WorkflowTask> iterator = workflowTasks.iterator();
                    while (iterator.hasNext() && !(task = iterator.next()).getTaskReferenceName().equals(taskReferenceName)) {
                        WorkflowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (!iterator.hasNext()) continue;
                    return iterator.next();
                }
                break;
            }
            case FORK_JOIN: {
                boolean found = false;
                for (List<WorkflowTask> workflowTasks : this.children()) {
                    Iterator<WorkflowTask> iterator = workflowTasks.iterator();
                    while (iterator.hasNext()) {
                        WorkflowTask task = iterator.next();
                        if (task.getTaskReferenceName().equals(taskReferenceName)) {
                            found = true;
                            break;
                        }
                        WorkflowTask nextTask = task.next(taskReferenceName, this);
                        if (nextTask != null) {
                            return nextTask;
                        }
                        if (!task.has(taskReferenceName)) continue;
                        break;
                    }
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    if (!found || parent == null) continue;
                    return parent.next(this.taskReferenceName, parent);
                }
                break;
            }
            case DYNAMIC: 
            case SIMPLE: {
                return null;
            }
        }
        return null;
    }

    public boolean has(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return true;
        }
        TaskType taskType = TaskType.USER_DEFINED;
        if (TaskType.isSystemTask(this.type)) {
            taskType = TaskType.valueOf(this.type);
        }
        switch (taskType) {
            case DECISION: 
            case FORK_JOIN: 
            case DO_WHILE: {
                for (List<WorkflowTask> childx : this.children()) {
                    for (WorkflowTask child : childx) {
                        if (!child.has(taskReferenceName)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public WorkflowTask get(String taskReferenceName) {
        if (this.getTaskReferenceName().equals(taskReferenceName)) {
            return this;
        }
        for (List<WorkflowTask> childx : this.children()) {
            for (WorkflowTask child : childx) {
                WorkflowTask found = child.get(taskReferenceName);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public String toString() {
        return this.name + "/" + this.taskReferenceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTask that = (WorkflowTask)o;
        return this.getStartDelay() == that.getStartDelay() && this.isOptional() == that.isOptional() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getTaskReferenceName(), that.getTaskReferenceName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getInputParameters(), that.getInputParameters()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getDynamicTaskNameParam(), that.getDynamicTaskNameParam()) && Objects.equals(this.getCaseValueParam(), that.getCaseValueParam()) && Objects.equals(this.getCaseExpression(), that.getCaseExpression()) && Objects.equals(this.getDecisionCases(), that.getDecisionCases()) && Objects.equals(this.getDynamicForkJoinTasksParam(), that.getDynamicForkJoinTasksParam()) && Objects.equals(this.getDynamicForkTasksParam(), that.getDynamicForkTasksParam()) && Objects.equals(this.getDynamicForkTasksInputParamName(), that.getDynamicForkTasksInputParamName()) && Objects.equals(this.getDefaultCase(), that.getDefaultCase()) && Objects.equals(this.getForkTasks(), that.getForkTasks()) && Objects.equals(this.getSubWorkflowParam(), that.getSubWorkflowParam()) && Objects.equals(this.getJoinOn(), that.getJoinOn()) && Objects.equals(this.getSink(), that.getSink()) && Objects.equals(this.isAsyncComplete(), that.isAsyncComplete()) && Objects.equals(this.getDefaultExclusiveJoinTask(), that.getDefaultExclusiveJoinTask());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getTaskReferenceName(), this.getDescription(), this.getInputParameters(), this.getType(), this.getDynamicTaskNameParam(), this.getCaseValueParam(), this.getCaseExpression(), this.getDecisionCases(), this.getDynamicForkJoinTasksParam(), this.getDynamicForkTasksParam(), this.getDynamicForkTasksInputParamName(), this.getDefaultCase(), this.getForkTasks(), this.getStartDelay(), this.getSubWorkflowParam(), this.getJoinOn(), this.getSink(), this.isAsyncComplete(), this.isOptional(), this.getDefaultExclusiveJoinTask());
    }

    @ProtoMessage(wrapper=true)
    public static class WorkflowTaskList {
        @ProtoField(id=1)
        private List<WorkflowTask> tasks;

        public List<WorkflowTask> getTasks() {
            return this.tasks;
        }

        public void setTasks(List<WorkflowTask> tasks) {
            this.tasks = tasks;
        }
    }

    @Deprecated
    public static enum Type {
        SIMPLE,
        DYNAMIC,
        FORK_JOIN,
        FORK_JOIN_DYNAMIC,
        DECISION,
        JOIN,
        SUB_WORKFLOW,
        EVENT,
        WAIT,
        USER_DEFINED;

        private static Set<String> systemTasks;

        public static boolean isSystemTask(String name) {
            return systemTasks.contains(name);
        }

        static {
            systemTasks = new HashSet<String>();
            systemTasks.add(SIMPLE.name());
            systemTasks.add(DYNAMIC.name());
            systemTasks.add(FORK_JOIN.name());
            systemTasks.add(FORK_JOIN_DYNAMIC.name());
            systemTasks.add(DECISION.name());
            systemTasks.add(JOIN.name());
            systemTasks.add(SUB_WORKFLOW.name());
            systemTasks.add(EVENT.name());
            systemTasks.add(WAIT.name());
        }
    }
}

