/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.github.vmg.protogen.annotations.ProtoEnum;
import com.github.vmg.protogen.annotations.ProtoField;
import com.github.vmg.protogen.annotations.ProtoMessage;
import com.netflix.conductor.common.constraints.TaskTimeoutConstraint;
import com.netflix.conductor.common.metadata.Auditable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@ProtoMessage
@TaskTimeoutConstraint
@Valid
public class TaskDef
extends Auditable {
    private static final int ONE_HOUR = 3600;
    @NotEmpty(message="TaskDef name cannot be null or empty")
    @ProtoField(id=1)
    private @NotEmpty(message="TaskDef name cannot be null or empty") String name;
    @ProtoField(id=2)
    private String description;
    @ProtoField(id=3)
    @Min(value=0L, message="TaskDef retryCount: {value} must be >= 0")
    private @Min(value=0L, message="TaskDef retryCount: {value} must be >= 0") int retryCount = 3;
    @ProtoField(id=4)
    @NotNull
    private long timeoutSeconds;
    @ProtoField(id=5)
    private List<String> inputKeys = new ArrayList<String>();
    @ProtoField(id=6)
    private List<String> outputKeys = new ArrayList<String>();
    @ProtoField(id=7)
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.TIME_OUT_WF;
    @ProtoField(id=8)
    private RetryLogic retryLogic = RetryLogic.FIXED;
    @ProtoField(id=9)
    private int retryDelaySeconds = 60;
    @ProtoField(id=10)
    @Min(value=1L, message="TaskDef responseTimeoutSeconds: ${validatedValue} should be minimum {value} second")
    private @Min(value=1L, message="TaskDef responseTimeoutSeconds: ${validatedValue} should be minimum {value} second") long responseTimeoutSeconds = 3600L;
    @ProtoField(id=11)
    private Integer concurrentExecLimit;
    @ProtoField(id=12)
    private Map<String, Object> inputTemplate = new HashMap<String, Object>();
    @ProtoField(id=14)
    private Integer rateLimitPerFrequency;
    @ProtoField(id=15)
    private Integer rateLimitFrequencyInSeconds;
    @ProtoField(id=16)
    private String isolationGroupId;
    @ProtoField(id=17)
    private String executionNameSpace;
    @ProtoField(id=18)
    @NotEmpty(message="ownerEmail cannot be empty")
    @Email(message="ownerEmail should be valid email address")
    private @NotEmpty(message="ownerEmail cannot be empty") @Email(message="ownerEmail should be valid email address") String ownerEmail;

    public TaskDef() {
    }

    public TaskDef(String name) {
        this.name = name;
    }

    public TaskDef(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public TaskDef(String name, String description, int retryCount, long timeoutSeconds) {
        this.name = name;
        this.description = description;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
    }

    public TaskDef(String name, String description, String ownerEmail, int retryCount, long timeoutSeconds, long responseTimeoutSeconds) {
        this.name = name;
        this.description = description;
        this.ownerEmail = ownerEmail;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public List<String> getInputKeys() {
        return this.inputKeys;
    }

    public void setInputKeys(List<String> inputKeys) {
        this.inputKeys = inputKeys;
    }

    public List<String> getOutputKeys() {
        return this.outputKeys;
    }

    public void setOutputKeys(List<String> outputKeys) {
        this.outputKeys = outputKeys;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public RetryLogic getRetryLogic() {
        return this.retryLogic;
    }

    public void setRetryLogic(RetryLogic retryLogic) {
        this.retryLogic = retryLogic;
    }

    public int getRetryDelaySeconds() {
        return this.retryDelaySeconds;
    }

    public long getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public void setResponseTimeoutSeconds(long responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public void setRetryDelaySeconds(int retryDelaySeconds) {
        this.retryDelaySeconds = retryDelaySeconds;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public Integer getRateLimitPerFrequency() {
        return this.rateLimitPerFrequency == null ? 0 : this.rateLimitPerFrequency;
    }

    public void setRateLimitPerFrequency(Integer rateLimitPerFrequency) {
        this.rateLimitPerFrequency = rateLimitPerFrequency;
    }

    public Integer getRateLimitFrequencyInSeconds() {
        return this.rateLimitFrequencyInSeconds == null ? 1 : this.rateLimitFrequencyInSeconds;
    }

    public void setRateLimitFrequencyInSeconds(Integer rateLimitFrequencyInSeconds) {
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
    }

    public void setConcurrentExecLimit(Integer concurrentExecLimit) {
        this.concurrentExecLimit = concurrentExecLimit;
    }

    public Integer getConcurrentExecLimit() {
        return this.concurrentExecLimit;
    }

    public int concurrencyLimit() {
        return this.concurrentExecLimit == null ? 0 : this.concurrentExecLimit;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public String getIsolationGroupId() {
        return this.isolationGroupId;
    }

    public void setIsolationGroupId(String isolationGroupId) {
        this.isolationGroupId = isolationGroupId;
    }

    public String getExecutionNameSpace() {
        return this.executionNameSpace;
    }

    public void setExecutionNameSpace(String executionNameSpace) {
        this.executionNameSpace = executionNameSpace;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDef taskDef = (TaskDef)o;
        return this.getRetryCount() == taskDef.getRetryCount() && this.getTimeoutSeconds() == taskDef.getTimeoutSeconds() && this.getRetryDelaySeconds() == taskDef.getRetryDelaySeconds() && this.getResponseTimeoutSeconds() == taskDef.getResponseTimeoutSeconds() && Objects.equals(this.getName(), taskDef.getName()) && Objects.equals(this.getDescription(), taskDef.getDescription()) && Objects.equals(this.getInputKeys(), taskDef.getInputKeys()) && Objects.equals(this.getOutputKeys(), taskDef.getOutputKeys()) && this.getTimeoutPolicy() == taskDef.getTimeoutPolicy() && this.getRetryLogic() == taskDef.getRetryLogic() && Objects.equals(this.getConcurrentExecLimit(), taskDef.getConcurrentExecLimit()) && Objects.equals(this.getRateLimitPerFrequency(), taskDef.getRateLimitPerFrequency()) && Objects.equals(this.getInputTemplate(), taskDef.getInputTemplate()) && Objects.equals(this.getIsolationGroupId(), taskDef.getIsolationGroupId()) && Objects.equals(this.getExecutionNameSpace(), taskDef.getExecutionNameSpace()) && Objects.equals(this.getOwnerEmail(), taskDef.getOwnerEmail());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getDescription(), this.getRetryCount(), this.getTimeoutSeconds(), this.getInputKeys(), this.getOutputKeys(), this.getTimeoutPolicy(), this.getRetryLogic(), this.getRetryDelaySeconds(), this.getResponseTimeoutSeconds(), this.getConcurrentExecLimit(), this.getRateLimitPerFrequency(), this.getInputTemplate(), this.getIsolationGroupId(), this.getExecutionNameSpace(), this.getOwnerEmail()});
    }

    @ProtoEnum
    public static enum RetryLogic {
        FIXED,
        EXPONENTIAL_BACKOFF;

    }

    @ProtoEnum
    public static enum TimeoutPolicy {
        RETRY,
        TIME_OUT_WF,
        ALERT_ONLY;

    }
}

