/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.servlet;

import com.netflix.concurrency.limits.limiter.AbstractPartitionedLimiter;
import java.security.Principal;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

public final class ServletLimiterBuilder
extends AbstractPartitionedLimiter.Builder<ServletLimiterBuilder, HttpServletRequest> {
    public ServletLimiterBuilder partitionByHeader(String name) {
        return (ServletLimiterBuilder)this.partitionResolver(request -> Optional.ofNullable(request.getHeader(name)).orElse(null));
    }

    public ServletLimiterBuilder partitionByUserPrincipal(Function<Principal, String> principalToGroup) {
        return (ServletLimiterBuilder)this.partitionResolver(request -> Optional.ofNullable(request.getUserPrincipal()).map(principalToGroup).orElse(null));
    }

    public ServletLimiterBuilder partitionByAttribute(String name) {
        return (ServletLimiterBuilder)this.partitionResolver(request -> Optional.ofNullable(request.getAttribute(name)).map(Object::toString).orElse(null));
    }

    public ServletLimiterBuilder partitionByParameter(String name) {
        return (ServletLimiterBuilder)this.partitionResolver(request -> Optional.ofNullable(request.getParameter(name)).orElse(null));
    }

    public ServletLimiterBuilder partitionByPathInfo(Function<String, String> pathToGroup) {
        return (ServletLimiterBuilder)this.partitionResolver(request -> Optional.ofNullable(request.getPathInfo()).map(pathToGroup).orElse(null));
    }

    public ServletLimiterBuilder bypassLimitByHeader(String name, String value) {
        return (ServletLimiterBuilder)this.bypassLimitResolver(context -> value.equals(context.getHeader(name)));
    }

    public ServletLimiterBuilder bypassLimitByAttribute(String name, String value) {
        return (ServletLimiterBuilder)this.bypassLimitResolver(context -> value.equals(context.getAttribute(name).toString()));
    }

    public ServletLimiterBuilder bypassLimitByParameter(String name, String value) {
        return (ServletLimiterBuilder)this.bypassLimitResolver(context -> value.equals(context.getParameter(name)));
    }

    public ServletLimiterBuilder bypassLimitByPathInfo(String pathInfo) {
        return (ServletLimiterBuilder)this.bypassLimitResolver(context -> pathInfo.equals(context.getPathInfo()));
    }

    public ServletLimiterBuilder bypassLimitByMethod(String method) {
        return (ServletLimiterBuilder)this.bypassLimitResolver(context -> method.equals(context.getMethod()));
    }

    protected ServletLimiterBuilder self() {
        return this;
    }
}

