/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.servlet;

import com.netflix.concurrency.limits.Limiter;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConcurrencyLimitServletFilter
implements Filter {
    private static final int STATUS_TOO_MANY_REQUESTS = 429;
    private final Limiter<HttpServletRequest> limiter;

    public ConcurrencyLimitServletFilter(Limiter<HttpServletRequest> limiter) {
        this.limiter = limiter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Optional listener = this.limiter.acquire((Object)((HttpServletRequest)request));
        if (listener.isPresent()) {
            try {
                chain.doFilter(request, response);
                ((Limiter.Listener)listener.get()).onSuccess();
            }
            catch (Exception e) {
                ((Limiter.Listener)listener.get()).onIgnore();
            }
        } else {
            this.outputThrottleError((HttpServletResponse)response);
        }
    }

    protected void outputThrottleError(HttpServletResponse response) {
        try {
            response.setStatus(429);
            response.getWriter().print("Concurrency limit exceeded");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void destroy() {
    }
}

