/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.grpc.client;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.grpc.client.GrpcClientRequestContext;
import com.netflix.concurrency.limits.limiter.AbstractPartitionedLimiter;
import com.netflix.concurrency.limits.limiter.BlockingLimiter;
import io.grpc.CallOptions;

public final class GrpcClientLimiterBuilder
extends AbstractPartitionedLimiter.Builder<GrpcClientLimiterBuilder, GrpcClientRequestContext> {
    private boolean blockOnLimit = false;

    public GrpcClientLimiterBuilder partitionByMethod() {
        return (GrpcClientLimiterBuilder)this.partitionResolver(context -> context.getMethod().getFullMethodName());
    }

    public GrpcClientLimiterBuilder partitionByCallOption(CallOptions.Key<String> option) {
        return (GrpcClientLimiterBuilder)this.partitionResolver(context -> (String)context.getCallOptions().getOption(option));
    }

    public <T> GrpcClientLimiterBuilder blockOnLimit(boolean blockOnLimit) {
        this.blockOnLimit = blockOnLimit;
        return this;
    }

    protected GrpcClientLimiterBuilder self() {
        return this;
    }

    public Limiter<GrpcClientRequestContext> build() {
        Limiter limiter = super.build();
        if (this.blockOnLimit) {
            limiter = BlockingLimiter.wrap((Limiter)limiter);
        }
        return limiter;
    }
}

