/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.limit.VegasLimit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class AbstractLimiter<ContextT>
implements Limiter<ContextT> {
    public static final String ID_TAG = "id";
    public static final String STATUS_TAG = "status";
    private final AtomicInteger inFlight = new AtomicInteger();
    private final Supplier<Long> clock;
    private final Limit limitAlgorithm;
    private final MetricRegistry.Counter successCounter;
    private final MetricRegistry.Counter droppedCounter;
    private final MetricRegistry.Counter ignoredCounter;
    private final MetricRegistry.Counter rejectedCounter;
    private final MetricRegistry.Counter bypassCounter;
    private final Predicate<ContextT> bypassResolver;
    private volatile int limit;

    protected AbstractLimiter(Builder<?> builder) {
        this.clock = ((Builder)builder).clock;
        this.limitAlgorithm = ((Builder)builder).limit;
        this.limit = this.limitAlgorithm.getLimit();
        this.limitAlgorithm.notifyOnChange(this::onNewLimit);
        this.bypassResolver = ((Builder)builder).bypassResolver;
        builder.registry.gauge("limit", this::getLimit, new String[0]);
        this.successCounter = builder.registry.counter("call", ID_TAG, builder.name, STATUS_TAG, "success");
        this.droppedCounter = builder.registry.counter("call", ID_TAG, builder.name, STATUS_TAG, "dropped");
        this.ignoredCounter = builder.registry.counter("call", ID_TAG, builder.name, STATUS_TAG, "ignored");
        this.rejectedCounter = builder.registry.counter("call", ID_TAG, builder.name, STATUS_TAG, "rejected");
        this.bypassCounter = builder.registry.counter("call", ID_TAG, builder.name, STATUS_TAG, "bypassed");
    }

    protected boolean shouldBypass(ContextT context) {
        return this.bypassResolver.test(context);
    }

    protected Optional<Limiter.Listener> createRejectedListener() {
        this.rejectedCounter.increment();
        return Optional.empty();
    }

    protected Optional<Limiter.Listener> createBypassListener() {
        this.bypassCounter.increment();
        return Optional.of(new Limiter.Listener(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onIgnore() {
            }

            @Override
            public void onDropped() {
            }
        });
    }

    protected Limiter.Listener createListener() {
        final long startTime = this.clock.get();
        final int currentInflight = this.inFlight.incrementAndGet();
        return new Limiter.Listener(){

            @Override
            public void onSuccess() {
                AbstractLimiter.this.inFlight.decrementAndGet();
                AbstractLimiter.this.successCounter.increment();
                AbstractLimiter.this.limitAlgorithm.onSample(startTime, (Long)AbstractLimiter.this.clock.get() - startTime, currentInflight, false);
            }

            @Override
            public void onIgnore() {
                AbstractLimiter.this.inFlight.decrementAndGet();
                AbstractLimiter.this.ignoredCounter.increment();
            }

            @Override
            public void onDropped() {
                AbstractLimiter.this.inFlight.decrementAndGet();
                AbstractLimiter.this.droppedCounter.increment();
                AbstractLimiter.this.limitAlgorithm.onSample(startTime, (Long)AbstractLimiter.this.clock.get() - startTime, currentInflight, true);
            }
        };
    }

    public int getLimit() {
        return this.limit;
    }

    public int getInflight() {
        return this.inFlight.get();
    }

    protected void onNewLimit(int newLimit) {
        this.limit = newLimit;
    }

    public static abstract class Builder<BuilderT extends Builder<BuilderT>> {
        private static final AtomicInteger idCounter = new AtomicInteger();
        private Limit limit = VegasLimit.newDefault();
        private Supplier<Long> clock = System::nanoTime;
        protected String name = "unnamed-" + idCounter.incrementAndGet();
        protected MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private final Predicate<Object> ALWAYS_FALSE = context -> false;
        private Predicate<Object> bypassResolver = this.ALWAYS_FALSE;

        public BuilderT named(String name) {
            this.name = name;
            return this.self();
        }

        public BuilderT limit(Limit limit) {
            this.limit = limit;
            return this.self();
        }

        public BuilderT clock(Supplier<Long> clock) {
            this.clock = clock;
            return this.self();
        }

        public BuilderT metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this.self();
        }

        protected abstract BuilderT self();

        protected final BuilderT bypassLimitResolverInternal(Predicate<?> shouldBypass) {
            this.bypassResolver = this.bypassResolver == this.ALWAYS_FALSE ? shouldBypass : this.bypassResolver.or(shouldBypass);
            return this.self();
        }
    }
}

