/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limiter;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public final class LifoBlockingLimiter<ContextT>
implements Limiter<ContextT> {
    private final Limiter<ContextT> delegate;
    private final Deque<ListenerHolder<ContextT>> backlog = new LinkedList<ListenerHolder<ContextT>>();
    private final AtomicInteger backlogCounter = new AtomicInteger();
    private final int backlogSize;
    private final Function<ContextT, Long> backlogTimeoutMillis;
    private final Object lock = new Object();

    public static <ContextT> Builder<ContextT> newBuilder(Limiter<ContextT> delegate) {
        return new Builder(delegate);
    }

    private LifoBlockingLimiter(Builder<ContextT> builder) {
        this.delegate = ((Builder)builder).delegate;
        this.backlogSize = ((Builder)builder).maxBacklogSize;
        this.backlogTimeoutMillis = ((Builder)builder).maxBacklogTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Limiter.Listener> tryAcquire(ContextT context) {
        Optional<Limiter.Listener> listener = this.delegate.acquire(context);
        if (listener.isPresent()) {
            return listener;
        }
        if (this.backlogCounter.get() >= this.backlogSize) {
            return Optional.empty();
        }
        this.backlogCounter.incrementAndGet();
        ListenerHolder<ContextT> event = new ListenerHolder<ContextT>(context);
        try {
            Object object = this.lock;
            synchronized (object) {
                this.backlog.addFirst(event);
            }
            if (!event.await(this.backlogTimeoutMillis.apply(context), TimeUnit.MILLISECONDS)) {
                object = this.lock;
                synchronized (object) {
                    this.backlog.removeLastOccurrence(event);
                }
                object = ((ListenerHolder)event).listener;
                return object;
            }
            object = ((ListenerHolder)event).listener;
            return object;
        }
        catch (InterruptedException e) {
            Object object = this.lock;
            synchronized (object) {
                this.backlog.removeFirstOccurrence(event);
            }
            Thread.currentThread().interrupt();
            object = ((ListenerHolder)event).listener;
            return object;
        }
        finally {
            this.backlogCounter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblock() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.backlog.isEmpty()) {
                ListenerHolder<ContextT> event = this.backlog.peekFirst();
                Optional<Limiter.Listener> listener = this.delegate.acquire(((ListenerHolder)event).context);
                if (listener.isPresent()) {
                    this.backlog.removeFirst();
                    event.set(listener);
                } else {
                    return;
                }
            }
        }
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        return this.tryAcquire(context).map(delegate -> new Limiter.Listener((Limiter.Listener)delegate){
            final /* synthetic */ Limiter.Listener val$delegate;
            {
                this.val$delegate = listener;
            }

            @Override
            public void onSuccess() {
                this.val$delegate.onSuccess();
                LifoBlockingLimiter.this.unblock();
            }

            @Override
            public void onIgnore() {
                this.val$delegate.onIgnore();
                LifoBlockingLimiter.this.unblock();
            }

            @Override
            public void onDropped() {
                this.val$delegate.onDropped();
                LifoBlockingLimiter.this.unblock();
            }
        });
    }

    public String toString() {
        return "BlockingLimiter [" + this.delegate + "]";
    }

    private static class ListenerHolder<ContextT> {
        private volatile Optional<Limiter.Listener> listener = Optional.empty();
        private final CountDownLatch latch = new CountDownLatch(1);
        private ContextT context;

        public ListenerHolder(ContextT context) {
            this.context = context;
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        public void set(Optional<Limiter.Listener> listener) {
            this.listener = listener;
            this.latch.countDown();
        }
    }

    public static class Builder<ContextT> {
        private final Limiter<ContextT> delegate;
        private int maxBacklogSize = 100;
        private Function<ContextT, Long> maxBacklogTimeoutMillis = context -> 1000L;

        private Builder(Limiter<ContextT> delegate) {
            this.delegate = delegate;
        }

        public Builder<ContextT> backlogSize(int size) {
            this.maxBacklogSize = size;
            return this;
        }

        @Deprecated
        public Builder<ContextT> maxBacklogSize(int size) {
            this.maxBacklogSize = size;
            return this;
        }

        public Builder<ContextT> backlogTimeout(long timeout, TimeUnit units) {
            return this.backlogTimeoutMillis(units.toMillis(timeout));
        }

        public Builder<ContextT> backlogTimeoutMillis(long timeout) {
            this.maxBacklogTimeoutMillis = context -> timeout;
            return this;
        }

        public Builder<ContextT> backlogTimeout(Function<ContextT, Long> mapper, TimeUnit units) {
            this.maxBacklogTimeoutMillis = context -> units.toMillis((Long)mapper.apply(context));
            return this;
        }

        public LifoBlockingLimiter<ContextT> build() {
            return new LifoBlockingLimiter(this);
        }
    }
}

