/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.measurement.ExpAvgMeasurement;
import com.netflix.concurrency.limits.limit.measurement.Measurement;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Gradient2Limit
extends AbstractLimit {
    private static final int DISABLED = -1;
    private static final Logger LOG = LoggerFactory.getLogger(Gradient2Limit.class);
    private volatile double estimatedLimit;
    private final Measurement shortRtt;
    private final Measurement longRtt;
    private final int maxLimit;
    private final int minLimit;
    private final Function<Integer, Integer> queueSize;
    private final double smoothing;
    private final MetricRegistry.SampleListener longRttSampleListener;
    private final MetricRegistry.SampleListener shortRttSampleListener;
    private final MetricRegistry.SampleListener queueSizeSampleListener;
    private final int maxDriftIntervals;
    private int intervalsAbove = 0;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Gradient2Limit newDefault() {
        return Gradient2Limit.newBuilder().build();
    }

    private Gradient2Limit(Builder builder) {
        super(builder.initialLimit);
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.minLimit = builder.minLimit;
        this.queueSize = builder.queueSize;
        this.smoothing = builder.smoothing;
        this.shortRtt = new ExpAvgMeasurement(builder.shortWindow, 10);
        this.longRtt = new ExpAvgMeasurement(builder.longWindow, 10);
        this.maxDriftIntervals = builder.shortWindow * builder.driftMultiplier;
        this.longRttSampleListener = builder.registry.registerDistribution("min_rtt", new String[0]);
        this.shortRttSampleListener = builder.registry.registerDistribution("min_window_rtt", new String[0]);
        this.queueSizeSampleListener = builder.registry.registerDistribution("queue_size", new String[0]);
    }

    @Override
    public int _update(long startTime, long rtt, int inflight, boolean didDrop) {
        double longRtt;
        double queueSize = this.queueSize.apply((int)this.estimatedLimit).intValue();
        double shortRtt = this.shortRtt.add(rtt).doubleValue();
        if (shortRtt > (longRtt = this.longRtt.add(rtt).doubleValue())) {
            ++this.intervalsAbove;
            if (this.intervalsAbove > this.maxDriftIntervals) {
                this.intervalsAbove = 0;
                int newLimit = (int)Math.max((double)this.minLimit, queueSize);
                this.longRtt.reset();
                this.estimatedLimit = newLimit;
                return (int)this.estimatedLimit;
            }
        } else {
            this.intervalsAbove = 0;
        }
        this.shortRttSampleListener.addSample(shortRtt);
        this.longRttSampleListener.addSample(longRtt);
        this.queueSizeSampleListener.addSample(queueSize);
        double gradient = Math.max(0.5, Math.min(1.0, longRtt / shortRtt));
        if ((double)inflight < this.estimatedLimit / 2.0) {
            return (int)this.estimatedLimit;
        }
        double newLimit = this.estimatedLimit * gradient + queueSize;
        if (newLimit < this.estimatedLimit) {
            newLimit = Math.max((double)this.minLimit, this.estimatedLimit * (1.0 - this.smoothing) + this.smoothing * newLimit);
        }
        if ((double)((int)this.estimatedLimit) != (newLimit = Math.max(queueSize, Math.min((double)this.maxLimit, newLimit)))) {
            LOG.debug("New limit={} shortRtt={} ms longRtt={} ms queueSize={} gradient={}", new Object[]{(int)newLimit, (double)this.getShortRtt(TimeUnit.MICROSECONDS) / 1000.0, (double)this.getLongRtt(TimeUnit.MICROSECONDS) / 1000.0, queueSize, gradient});
        }
        this.estimatedLimit = newLimit;
        return (int)this.estimatedLimit;
    }

    public long getShortRtt(TimeUnit units) {
        return units.convert(this.shortRtt.get().longValue(), TimeUnit.NANOSECONDS);
    }

    public long getLongRtt(TimeUnit units) {
        return units.convert(this.longRtt.get().longValue(), TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "GradientLimit [limit=" + (int)this.estimatedLimit + "]";
    }

    public static class Builder {
        private int initialLimit = 4;
        private int minLimit = 4;
        private int maxConcurrency = 1000;
        private double smoothing = 0.2;
        private Function<Integer, Integer> queueSize = concurrency -> 4;
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private int shortWindow = 10;
        private int longWindow = 100;
        private int driftMultiplier = 5;

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder minLimit(int minLimit) {
            this.minLimit = minLimit;
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder queueSize(int queueSize) {
            this.queueSize = ignore -> queueSize;
            return this;
        }

        public Builder queueSize(Function<Integer, Integer> queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public Builder driftMultiplier(int multiplier) {
            this.driftMultiplier = multiplier;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder shortWindow(int n) {
            this.shortWindow = n;
            return this;
        }

        public Builder longWindow(int n) {
            this.longWindow = n;
            return this;
        }

        public Gradient2Limit build() {
            return new Gradient2Limit(this);
        }
    }
}

