/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.window;

import com.netflix.concurrency.limits.limit.window.SampleWindow;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

class ImmutablePercentileSampleWindow
implements SampleWindow {
    private final long minRtt;
    private final int maxInFlight;
    private final boolean didDrop;
    private final List<Long> observedRtts;
    private final double percentile;

    ImmutablePercentileSampleWindow(double percentile) {
        this.minRtt = Long.MAX_VALUE;
        this.maxInFlight = 0;
        this.didDrop = false;
        this.observedRtts = new ArrayList<Long>();
        this.percentile = percentile;
    }

    ImmutablePercentileSampleWindow(long minRtt, int maxInFlight, boolean didDrop, List<Long> observedRtts, double percentile) {
        this.minRtt = minRtt;
        this.maxInFlight = maxInFlight;
        this.didDrop = didDrop;
        this.observedRtts = observedRtts;
        this.percentile = percentile;
    }

    @Override
    public ImmutablePercentileSampleWindow addSample(long rtt, int inflight) {
        ArrayList<Long> newObservedRtts = new ArrayList<Long>(this.observedRtts);
        newObservedRtts.add(rtt);
        return new ImmutablePercentileSampleWindow(Math.min(this.minRtt, rtt), Math.max(inflight, this.maxInFlight), this.didDrop, newObservedRtts, this.percentile);
    }

    @Override
    public ImmutablePercentileSampleWindow addDroppedSample(int inflight) {
        return new ImmutablePercentileSampleWindow(this.minRtt, Math.max(inflight, this.maxInFlight), true, this.observedRtts, this.percentile);
    }

    @Override
    public long getCandidateRttNanos() {
        return this.minRtt;
    }

    @Override
    public long getTrackedRttNanos() {
        this.observedRtts.sort(Comparator.naturalOrder());
        int rttIndex = (int)Math.round((double)this.observedRtts.size() * this.percentile);
        int zeroBasedRttIndex = rttIndex - 1;
        return this.observedRtts.get(zeroBasedRttIndex);
    }

    @Override
    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    @Override
    public int getSampleCount() {
        return this.observedRtts.size();
    }

    @Override
    public boolean didDrop() {
        return this.didDrop;
    }

    public String toString() {
        return "ImmutablePercentileSampleWindow [minRtt=" + (double)TimeUnit.NANOSECONDS.toMicros(this.minRtt) / 1000.0 + ", p" + this.percentile + " rtt=" + (double)TimeUnit.NANOSECONDS.toMicros(this.getTrackedRttNanos()) / 1000.0 + ", maxInFlight=" + this.maxInFlight + ", sampleCount=" + this.observedRtts.size() + ", didDrop=" + this.didDrop + "]";
    }
}

