/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.window;

import com.netflix.concurrency.limits.limit.window.SampleWindow;
import java.util.concurrent.TimeUnit;

class ImmutableAverageSampleWindow
implements SampleWindow {
    private final long minRtt;
    private final long sum;
    private final int maxInFlight;
    private final int sampleCount;
    private final boolean didDrop;

    ImmutableAverageSampleWindow() {
        this.minRtt = Long.MAX_VALUE;
        this.sum = 0L;
        this.maxInFlight = 0;
        this.sampleCount = 0;
        this.didDrop = false;
    }

    ImmutableAverageSampleWindow(long minRtt, long sum, int maxInFlight, int sampleCount, boolean didDrop) {
        this.minRtt = minRtt;
        this.sum = sum;
        this.maxInFlight = maxInFlight;
        this.sampleCount = sampleCount;
        this.didDrop = didDrop;
    }

    @Override
    public ImmutableAverageSampleWindow addSample(long rtt, int inflight) {
        return new ImmutableAverageSampleWindow(Math.min(rtt, this.minRtt), this.sum + rtt, Math.max(inflight, this.maxInFlight), this.sampleCount + 1, this.didDrop);
    }

    @Override
    public ImmutableAverageSampleWindow addDroppedSample(int inflight) {
        return new ImmutableAverageSampleWindow(this.minRtt, this.sum, Math.max(inflight, this.maxInFlight), this.sampleCount, true);
    }

    @Override
    public long getCandidateRttNanos() {
        return this.minRtt;
    }

    @Override
    public long getTrackedRttNanos() {
        return this.sampleCount == 0 ? 0L : this.sum / (long)this.sampleCount;
    }

    @Override
    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public boolean didDrop() {
        return this.didDrop;
    }

    public String toString() {
        return "ImmutableAverageSampleWindow [minRtt=" + (double)TimeUnit.NANOSECONDS.toMicros(this.minRtt) / 1000.0 + ", avgRtt=" + (double)TimeUnit.NANOSECONDS.toMicros(this.getTrackedRttNanos()) / 1000.0 + ", maxInFlight=" + this.maxInFlight + ", sampleCount=" + this.sampleCount + ", didDrop=" + this.didDrop + "]";
    }
}

