/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.limit.AbstractLimit;

public final class AIMDLimit
extends AbstractLimit {
    private final double backoffRatio;

    public static Builder newBuilder() {
        return new Builder();
    }

    private AIMDLimit(Builder builder) {
        super(builder.initialLimit);
        this.backoffRatio = builder.backoffRatio;
    }

    @Override
    protected int _update(long startTime, long rtt, int inflight, boolean didDrop) {
        if (didDrop) {
            return Math.max(1, Math.min(this.getLimit() - 1, (int)((double)this.getLimit() * this.backoffRatio)));
        }
        if (inflight >= this.getLimit()) {
            return this.getLimit() + 1;
        }
        return this.getLimit();
    }

    public String toString() {
        return "AIMDLimit [limit=" + this.getLimit() + "]";
    }

    public static class Builder {
        private int initialLimit = 10;
        private double backoffRatio = 0.9;

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder backoffRatio(double backoffRatio) {
            this.backoffRatio = backoffRatio;
            return this;
        }

        public AIMDLimit build() {
            return new AIMDLimit(this);
        }
    }
}

