/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import com.netflix.concurrency.limits.limiter.SimpleLimiter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractPartitionedLimiter<ContextT>
extends AbstractLimiter<ContextT> {
    private static final String PARTITION_TAG_NAME = "partition";
    private final Map<String, Partition> partitions;
    private final Partition unknownPartition;
    private final List<Function<ContextT, String>> partitionResolvers;

    public AbstractPartitionedLimiter(Builder<?, ContextT> builder) {
        super(builder);
        Preconditions.checkArgument(!((Builder)builder).partitions.isEmpty(), "No partitions specified");
        Preconditions.checkArgument(((Builder)builder).partitions.values().stream().map(Partition::getPercent).reduce(0.0, Double::sum) <= 1.0, "Sum of percentages must be <= 1.0");
        this.partitions = new HashMap<String, Partition>(((Builder)builder).partitions);
        this.partitions.forEach((name, partition) -> partition.createMetrics(builder.registry));
        this.unknownPartition = new Partition("unknown", 0.0);
        this.unknownPartition.createMetrics(builder.registry);
        this.partitionResolvers = ((Builder)builder).partitionResolvers;
        builder.registry.registerGauge("limit", this::getLimit, new String[0]);
        this.onNewLimit(this.getLimit());
    }

    private Partition resolvePartition(ContextT context) {
        for (Function<ContextT, String> resolver : this.partitionResolvers) {
            Partition partition;
            String name = resolver.apply(context);
            if (name == null || (partition = this.partitions.get(name)) == null) continue;
            return partition;
        }
        return this.unknownPartition;
    }

    @Override
    public synchronized Optional<Limiter.Listener> acquire(ContextT context) {
        final Partition partition = this.resolvePartition(context);
        if (this.getInflight() >= this.getLimit() && partition.isLimitExceeded()) {
            return Optional.empty();
        }
        partition.acquire();
        final Limiter.Listener listener = this.createListener();
        return Optional.of(new Limiter.Listener(){

            @Override
            public void onSuccess() {
                listener.onSuccess();
                AbstractPartitionedLimiter.this.releasePartition(partition);
            }

            @Override
            public void onIgnore() {
                listener.onIgnore();
                AbstractPartitionedLimiter.this.releasePartition(partition);
            }

            @Override
            public void onDropped() {
                listener.onDropped();
                AbstractPartitionedLimiter.this.releasePartition(partition);
            }
        });
    }

    private synchronized void releasePartition(Partition partition) {
        partition.release();
    }

    @Override
    protected synchronized void onNewLimit(int newLimit) {
        this.partitions.forEach((name, partition) -> partition.updateLimit(newLimit));
    }

    Partition getPartition(String name) {
        return this.partitions.get(name);
    }

    static class Partition {
        private final double percent;
        private final String name;
        private int limit;
        private int busy;
        private MetricRegistry.SampleListener inflightDistribution;

        Partition(String name, double pct) {
            this.name = name;
            this.percent = pct;
        }

        void updateLimit(int totalLimit) {
            this.limit = (int)Math.max(1.0, Math.ceil((double)totalLimit * this.percent));
        }

        boolean isLimitExceeded() {
            return this.busy >= this.limit;
        }

        void acquire() {
            ++this.busy;
        }

        void release() {
            --this.busy;
        }

        int getLimit() {
            return this.limit;
        }

        public int getInflight() {
            return this.busy;
        }

        double getPercent() {
            return this.percent;
        }

        void createMetrics(MetricRegistry registry) {
            this.inflightDistribution = registry.registerDistribution("inflight", AbstractPartitionedLimiter.PARTITION_TAG_NAME, this.name);
            registry.registerGauge("limit.partition", this::getLimit, AbstractPartitionedLimiter.PARTITION_TAG_NAME, this.name);
        }

        public String toString() {
            return "Partition [pct=" + this.percent + ", limit=" + this.limit + ", busy=" + this.busy + "]";
        }
    }

    public static abstract class Builder<BuilderT extends AbstractLimiter.Builder<BuilderT, ContextT>, ContextT>
    extends AbstractLimiter.Builder<BuilderT, ContextT> {
        private List<Function<ContextT, String>> partitionResolvers = new ArrayList<Function<ContextT, String>>();
        private final Map<String, Partition> partitions = new LinkedHashMap<String, Partition>();

        public BuilderT partitionResolver(Function<ContextT, String> contextToPartition) {
            this.partitionResolvers.add(contextToPartition);
            return this.self();
        }

        public BuilderT partition(String name, double percent) {
            this.partitions.put(name, new Partition(name, percent));
            return this.self();
        }

        protected boolean hasPartitions() {
            return !this.partitions.isEmpty();
        }

        public Limiter<ContextT> build() {
            return this.hasPartitions() && !this.partitionResolvers.isEmpty() ? new AbstractPartitionedLimiter<ContextT>(this){} : new SimpleLimiter(this);
        }
    }
}

