/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.measurement;

import com.netflix.concurrency.limits.limit.measurement.Measurement;
import java.util.function.Function;

public class ExpAvgMeasurement
implements Measurement {
    private Double value = 0.0;
    private final int window;
    private int count = 0;

    public ExpAvgMeasurement(int window) {
        this.window = window;
    }

    @Override
    public Number add(Number sample) {
        if (this.count == 0) {
            ++this.count;
            this.value = sample.doubleValue();
        } else if (this.count < this.window) {
            ++this.count;
            double factor = ExpAvgMeasurement.factor(this.count);
            this.value = this.value * (1.0 - factor) + sample.doubleValue() * factor;
        } else {
            double factor = ExpAvgMeasurement.factor(this.window);
            this.value = this.value * (1.0 - factor) + sample.doubleValue() * factor;
        }
        return this.value;
    }

    private static double factor(int n) {
        return 2.0 / (double)(n + 1);
    }

    @Override
    public Number get() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0.0;
        this.count = 0;
    }

    @Override
    public void update(Function<Number, Number> operation) {
        this.value = operation.apply(this.value).doubleValue();
    }
}

