/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.ImmutableSampleWindow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class WindowedLimit
implements Limit {
    private static final long DEFAULT_MIN_WINDOW_TIME = TimeUnit.SECONDS.toNanos(1L);
    private static final long DEFAULT_MAX_WINDOW_TIME = TimeUnit.SECONDS.toNanos(1L);
    private static final long DEFAULT_MIN_RTT_THRESHOLD = TimeUnit.MICROSECONDS.toNanos(100L);
    private static final int DEFAULT_WINDOW_SIZE = 100;
    private final Limit delegate;
    private volatile long nextUpdateTime = 0L;
    private final long minWindowTime;
    private final long maxWindowTime;
    private final int windowSize;
    private final long minRttThreshold;
    private final Object lock = new Object();
    private final AtomicReference<ImmutableSampleWindow> sample = new AtomicReference<ImmutableSampleWindow>(new ImmutableSampleWindow());

    public static Builder newBuilder() {
        return new Builder();
    }

    private WindowedLimit(Builder builder, Limit delegate) {
        this.delegate = delegate;
        this.minWindowTime = builder.minWindowTime;
        this.maxWindowTime = builder.maxWindowTime;
        this.windowSize = builder.windowSize;
        this.minRttThreshold = builder.minRttThreshold;
    }

    @Override
    public void notifyOnChange(Consumer<Integer> consumer) {
        this.delegate.notifyOnChange(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSample(long startTime, long rtt, int inflight, boolean didDrop) {
        long endTime = startTime + rtt;
        if (rtt < this.minRttThreshold) {
            return;
        }
        if (didDrop) {
            this.sample.updateAndGet(current -> current.addDroppedSample(inflight));
        } else {
            this.sample.updateAndGet(window -> window.addSample(rtt, inflight));
        }
        if (startTime + rtt > this.nextUpdateTime) {
            Object object = this.lock;
            synchronized (object) {
                ImmutableSampleWindow current2;
                if (endTime > this.nextUpdateTime && this.isWindowReady(current2 = this.sample.get())) {
                    this.sample.set(new ImmutableSampleWindow());
                    this.nextUpdateTime = endTime + Math.min(Math.max(current2.getCandidateRttNanos() * 2L, this.minWindowTime), this.maxWindowTime);
                    this.delegate.onSample(startTime, current2.getAverateRttNanos(), current2.getMaxInFlight(), current2.didDrop());
                }
            }
        }
    }

    private boolean isWindowReady(ImmutableSampleWindow sample) {
        return sample.getCandidateRttNanos() < Long.MAX_VALUE && sample.getSampleCount() > this.windowSize;
    }

    @Override
    public int getLimit() {
        return this.delegate.getLimit();
    }

    static /* synthetic */ long access$000() {
        return DEFAULT_MAX_WINDOW_TIME;
    }

    static /* synthetic */ long access$100() {
        return DEFAULT_MIN_WINDOW_TIME;
    }

    static /* synthetic */ long access$200() {
        return DEFAULT_MIN_RTT_THRESHOLD;
    }

    public static class Builder {
        private long maxWindowTime = WindowedLimit.access$000();
        private long minWindowTime = WindowedLimit.access$100();
        private int windowSize = 100;
        private long minRttThreshold = WindowedLimit.access$200();

        public Builder minWindowTime(long minWindowTime, TimeUnit units) {
            Preconditions.checkArgument(units.toMillis(minWindowTime) >= 100L, "minWindowTime must be >= 100 ms");
            this.minWindowTime = units.toNanos(minWindowTime);
            return this;
        }

        public Builder maxWindowTime(long maxWindowTime, TimeUnit units) {
            Preconditions.checkArgument(maxWindowTime >= units.toMillis(100L), "minWindowTime must be >= 100 ms");
            this.maxWindowTime = units.toNanos(maxWindowTime);
            return this;
        }

        public Builder windowSize(int windowSize) {
            Preconditions.checkArgument(windowSize >= 10, "Window size must be >= 10");
            this.windowSize = windowSize;
            return this;
        }

        public Builder minRttThreshold(long threshold, TimeUnit units) {
            this.minRttThreshold = units.toNanos(threshold);
            return this;
        }

        public WindowedLimit build(Limit delegate) {
            return new WindowedLimit(this, delegate);
        }
    }
}

