/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.functions.SquareRootFunction;
import com.netflix.concurrency.limits.limit.measurement.Measurement;
import com.netflix.concurrency.limits.limit.measurement.MinimumMeasurement;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GradientLimit
extends AbstractLimit {
    private static final int DISABLED = -1;
    private static final Logger LOG = LoggerFactory.getLogger(GradientLimit.class);
    private volatile double estimatedLimit;
    private final Measurement rttNoLoadMeasurement;
    private final int maxLimit;
    private final int minLimit;
    private final Function<Integer, Integer> queueSize;
    private final double smoothing;
    private final double rttTolerance;
    private final MetricRegistry.SampleListener minRttSampleListener;
    private final MetricRegistry.SampleListener minWindowRttSampleListener;
    private final MetricRegistry.SampleListener queueSizeSampleListener;
    private final int probeInterval;
    private int resetRttCounter;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static GradientLimit newDefault() {
        return GradientLimit.newBuilder().build();
    }

    private GradientLimit(Builder builder) {
        super(builder.initialLimit);
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.minLimit = builder.minLimit;
        this.queueSize = builder.queueSize;
        this.smoothing = builder.smoothing;
        this.rttTolerance = builder.rttTolerance;
        this.probeInterval = builder.probeInterval;
        this.resetRttCounter = this.nextProbeCountdown();
        this.rttNoLoadMeasurement = new MinimumMeasurement();
        this.minRttSampleListener = builder.registry.registerDistribution("min_rtt", new String[0]);
        this.minWindowRttSampleListener = builder.registry.registerDistribution("min_window_rtt", new String[0]);
        this.queueSizeSampleListener = builder.registry.registerDistribution("queue_size", new String[0]);
    }

    private int nextProbeCountdown() {
        if (this.probeInterval == -1) {
            return -1;
        }
        return this.probeInterval + ThreadLocalRandom.current().nextInt(this.probeInterval);
    }

    @Override
    public int _update(long startTime, long rtt, int inflight, boolean didDrop) {
        double newLimit;
        this.minWindowRttSampleListener.addSample(rtt);
        double queueSize = this.queueSize.apply((int)this.estimatedLimit).intValue();
        this.queueSizeSampleListener.addSample(queueSize);
        if (this.probeInterval != -1 && this.resetRttCounter-- <= 0) {
            this.resetRttCounter = this.nextProbeCountdown();
            this.estimatedLimit = Math.max((double)this.minLimit, queueSize);
            this.rttNoLoadMeasurement.reset();
            LOG.debug("Probe MinRTT limit={}", (Object)this.getLimit());
            return (int)this.estimatedLimit;
        }
        long rttNoLoad = this.rttNoLoadMeasurement.add(rtt).longValue();
        this.minRttSampleListener.addSample(rttNoLoad);
        double gradient = Math.max(0.5, Math.min(1.0, this.rttTolerance * (double)rttNoLoad / (double)rtt));
        if (didDrop) {
            newLimit = this.estimatedLimit / 2.0;
        } else if ((double)inflight < this.estimatedLimit / 2.0) {
            return (int)this.estimatedLimit;
        }
        newLimit = this.estimatedLimit * gradient + queueSize;
        if (newLimit < this.estimatedLimit) {
            newLimit = Math.max((double)this.minLimit, this.estimatedLimit * (1.0 - this.smoothing) + this.smoothing * newLimit);
        }
        if ((int)(newLimit = Math.max(queueSize, Math.min((double)this.maxLimit, newLimit))) != (int)this.estimatedLimit && LOG.isDebugEnabled()) {
            LOG.debug("New limit={} minRtt={} ms winRtt={} ms queueSize={} gradient={} resetCounter={}", new Object[]{(int)newLimit, (double)TimeUnit.NANOSECONDS.toMicros(rttNoLoad) / 1000.0, (double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0, queueSize, gradient, this.resetRttCounter});
        }
        this.estimatedLimit = newLimit;
        return (int)this.estimatedLimit;
    }

    public long getRttNoLoad() {
        return this.rttNoLoadMeasurement.get().longValue();
    }

    public String toString() {
        return "GradientLimit [limit=" + (int)this.estimatedLimit + ", rtt_noload=" + (double)TimeUnit.MICROSECONDS.toMillis(this.rttNoLoadMeasurement.get().longValue()) / 1000.0 + " ms]";
    }

    public static class Builder {
        private int initialLimit = 50;
        private int minLimit = 1;
        private int maxConcurrency = 1000;
        private double smoothing = 0.2;
        private Function<Integer, Integer> queueSize = SquareRootFunction.create(4);
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private double rttTolerance = 2.0;
        private int probeInterval = 1000;

        @Deprecated
        public Builder minRttThreshold(long minRttTreshold, TimeUnit units) {
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder minLimit(int minLimit) {
            this.minLimit = minLimit;
            return this;
        }

        public Builder rttTolerance(double rttTolerance) {
            Preconditions.checkArgument(rttTolerance >= 1.0, "Tolerance must be >= 1.0");
            this.rttTolerance = rttTolerance;
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder queueSize(int queueSize) {
            this.queueSize = ignore -> queueSize;
            return this;
        }

        public Builder queueSize(Function<Integer, Integer> queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        @Deprecated
        public Builder probeMultiplier(int probeMultiplier) {
            return this;
        }

        public Builder probeInterval(int probeInterval) {
            this.probeInterval = probeInterval;
            return this;
        }

        public GradientLimit build() {
            return new GradientLimit(this);
        }
    }
}

