/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VegasLimit
implements Limit {
    private static final Logger LOG = LoggerFactory.getLogger(VegasLimit.class);
    private volatile int estimatedLimit;
    private volatile long rtt_noload = 0L;
    private boolean didDrop = false;
    private final int maxLimit;
    private final double tolerance;
    private final Function<Integer, Integer> alphaFunc;
    private final Function<Integer, Integer> betaFunc;
    private final double backoffRatio;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VegasLimit newDefault() {
        return VegasLimit.newBuilder().build();
    }

    private VegasLimit(Builder builder) {
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.alphaFunc = builder.alpha;
        this.betaFunc = builder.beta;
        this.backoffRatio = builder.backoffRatio;
        this.tolerance = builder.tolerance;
        builder.registry.registerGauge("min_rtt", () -> this.rtt_noload, new String[0]);
    }

    @Override
    public synchronized void update(long rtt) {
        Preconditions.checkArgument(rtt > 0L, "rtt must be >0 but got " + rtt);
        if (this.rtt_noload == 0L || rtt < this.rtt_noload) {
            LOG.debug("New MinRTT {}", (Object)rtt);
            this.rtt_noload = rtt;
        }
        if (this.didDrop) {
            this.didDrop = false;
        } else {
            int newLimit = this.estimatedLimit;
            long adjusted_rtt = (double)rtt < (double)this.rtt_noload * this.tolerance ? this.rtt_noload : rtt;
            int alpha = this.alphaFunc.apply(this.estimatedLimit);
            int beta = this.betaFunc.apply(this.estimatedLimit);
            int queueSize = (int)Math.ceil((double)this.estimatedLimit * (1.0 - (double)this.rtt_noload / (double)adjusted_rtt));
            if (queueSize <= alpha) {
                newLimit += alpha;
            } else if (queueSize > beta) {
                newLimit -= alpha;
            }
            newLimit = Math.max(1, Math.min(this.maxLimit, newLimit));
            if (newLimit != this.estimatedLimit) {
                this.estimatedLimit = newLimit;
                LOG.debug("New limit={} minRtt={} \u03bcs winRtt={} \u03bcs queueSize={}", new Object[]{this.estimatedLimit, TimeUnit.NANOSECONDS.toMicros(this.rtt_noload), TimeUnit.NANOSECONDS.toMicros(rtt), queueSize});
            }
        }
    }

    @Override
    public synchronized void drop() {
        if (!this.didDrop) {
            this.didDrop = true;
            this.estimatedLimit = Math.max(1, Math.min(this.estimatedLimit - 1, (int)((double)this.estimatedLimit * this.backoffRatio)));
        }
    }

    @Override
    public int getLimit() {
        return this.estimatedLimit;
    }

    public String toString() {
        return "VegasLimit [limit=" + this.estimatedLimit + ", rtt_noload=" + TimeUnit.NANOSECONDS.toMillis(this.rtt_noload) + "]";
    }

    public static class Builder {
        private int initialLimit = 20;
        private int maxConcurrency = 1000;
        private Function<Integer, Integer> alpha = limit -> Math.max(3, limit / 10);
        private Function<Integer, Integer> beta = limit -> Math.max(6, limit / 5);
        private double tolerance = 1.0;
        private double backoffRatio = 0.9;
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;

        public Builder alpha(int alpha) {
            this.alpha = ignore -> alpha;
            return this;
        }

        public Builder alpha(Function<Integer, Integer> alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder beta(int beta) {
            this.beta = ignore -> beta;
            return this;
        }

        public Builder beta(Function<Integer, Integer> beta) {
            this.beta = beta;
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder backoffRatio(double ratio) {
            this.backoffRatio = ratio;
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder tolerance(double tolerance) {
            Preconditions.checkArgument(tolerance >= 1.0, "Tolerance must be >= 1");
            this.tolerance = tolerance;
            return this;
        }

        @Deprecated
        public Builder fastStartEnabled(boolean fastStartEnabled) {
            return this;
        }

        public VegasLimit build() {
            return new VegasLimit(this);
        }
    }
}

