/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.Strategy;
import com.netflix.concurrency.limits.internal.Preconditions;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public final class DefaultLimiter<ContextT>
implements Limiter<ContextT> {
    private final Supplier<Long> nanoClock = System::nanoTime;
    private final long MIN_WINDOW_SIZE = TimeUnit.MILLISECONDS.toNanos(200L);
    private volatile long RTT_noload = TimeUnit.MILLISECONDS.toNanos(100L);
    private final AtomicLong RTT_candidate = new AtomicLong(Integer.MAX_VALUE);
    private volatile boolean isAppLimited = false;
    private final AtomicLong nextUpdateTime = new AtomicLong();
    private final Limit limit;
    private final Strategy<ContextT> strategy;

    public DefaultLimiter(Limit limit, Strategy<ContextT> strategy) {
        Preconditions.checkArgument(limit != null, "Algorithm may not be null");
        Preconditions.checkArgument(strategy != null, "Strategy may not be null");
        this.limit = limit;
        this.strategy = strategy;
        strategy.setLimit(limit.getLimit());
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        long startTime = this.nanoClock.get();
        Optional<Strategy.Token> optionalToken = this.strategy.tryAcquire(context);
        if (!optionalToken.isPresent()) {
            this.isAppLimited = false;
        }
        return optionalToken.map(token -> new Limiter.Listener((Strategy.Token)token, startTime){
            final /* synthetic */ Strategy.Token val$token;
            final /* synthetic */ long val$startTime;
            {
                this.val$token = token;
                this.val$startTime = l;
            }

            @Override
            public void onSuccess() {
                long updateTime;
                long current;
                this.val$token.release();
                long endTime = (Long)DefaultLimiter.this.nanoClock.get();
                long rtt = endTime - this.val$startTime;
                if (rtt < DefaultLimiter.this.RTT_noload) {
                    DefaultLimiter.this.RTT_noload = rtt;
                }
                if (rtt < (current = DefaultLimiter.this.RTT_candidate.get())) {
                    DefaultLimiter.this.RTT_candidate.compareAndSet(current, rtt);
                    current = rtt;
                }
                if (endTime >= (updateTime = DefaultLimiter.this.nextUpdateTime.get()) && DefaultLimiter.this.nextUpdateTime.compareAndSet(updateTime, endTime + Math.max(DefaultLimiter.this.MIN_WINDOW_SIZE, DefaultLimiter.this.RTT_noload * 20L)) && !DefaultLimiter.this.isAppLimited && current != Integer.MAX_VALUE && DefaultLimiter.this.RTT_candidate.compareAndSet(current, Integer.MAX_VALUE)) {
                    DefaultLimiter.this.limit.update(current);
                    DefaultLimiter.this.strategy.setLimit(DefaultLimiter.this.limit.getLimit());
                    DefaultLimiter.this.isAppLimited = true;
                }
            }

            @Override
            public void onIgnore() {
                this.val$token.release();
            }

            @Override
            public void onDropped() {
                this.val$token.release();
                DefaultLimiter.this.limit.drop();
                DefaultLimiter.this.strategy.setLimit(DefaultLimiter.this.limit.getLimit());
            }
        });
    }

    protected int getLimit() {
        return this.limit.getLimit();
    }

    public String toString() {
        return "DefaultLimiter [RTT_noload=" + TimeUnit.NANOSECONDS.toMillis(this.RTT_noload) + ", RTT_candidate=" + TimeUnit.NANOSECONDS.toMillis(this.RTT_candidate.get()) + ", isAppLimited=" + this.isAppLimited + ", " + this.limit + ", " + this.strategy + "]";
    }
}

