/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import java.util.concurrent.TimeUnit;

public class VegasLimit
implements Limit {
    private volatile int estimatedLimit;
    private volatile long rtt_noload;
    private boolean didDrop = false;
    private final int maxLimit;
    private final int alpha;
    private final int beta;
    private final double backoffRatio;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VegasLimit newDefault() {
        return VegasLimit.newBuilder().build();
    }

    private VegasLimit(Builder builder) {
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.alpha = builder.alpha;
        this.beta = builder.beta;
        this.backoffRatio = builder.backoffRatio;
        builder.registry.registerGuage("min_rtt", () -> this.rtt_noload, new String[0]);
    }

    @Override
    public synchronized void update(long rtt) {
        Preconditions.checkArgument(rtt > 0L, "rtt must be >0 but got " + rtt);
        if (this.rtt_noload == 0L || rtt < this.rtt_noload) {
            this.rtt_noload = rtt;
        }
        if (this.didDrop) {
            this.didDrop = false;
        } else {
            int newLimit = this.estimatedLimit;
            int queueSize = (int)Math.ceil((double)this.estimatedLimit * (1.0 - (double)this.rtt_noload / (double)rtt));
            if (queueSize <= this.alpha) {
                ++newLimit;
            } else if (queueSize >= this.beta) {
                --newLimit;
            }
            this.estimatedLimit = Math.max(1, Math.min(this.maxLimit, newLimit));
        }
    }

    @Override
    public synchronized void drop() {
        if (!this.didDrop) {
            this.didDrop = true;
            this.estimatedLimit = Math.max(1, Math.min(this.estimatedLimit - 1, (int)((double)this.estimatedLimit * this.backoffRatio)));
        }
    }

    @Override
    public int getLimit() {
        return this.estimatedLimit;
    }

    public String toString() {
        return "VegasLimit [limit=" + this.estimatedLimit + ", rtt_noload=" + TimeUnit.NANOSECONDS.toMillis(this.rtt_noload) + "]";
    }

    public static class Builder {
        private int initialLimit = 10;
        private int maxConcurrency = 100;
        private int alpha = 2;
        private int beta = 4;
        private double backoffRatio = 0.9;
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;

        public Builder alpha(int alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder beta(int beta) {
            this.beta = beta;
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder backoffRatio(double ratio) {
            this.backoffRatio = ratio;
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public VegasLimit build() {
            return new VegasLimit(this);
        }
    }
}

