/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.functions.Log10RootFunction;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VegasLimit
implements Limit {
    private static final Logger LOG = LoggerFactory.getLogger(VegasLimit.class);
    private static final Function<Integer, Integer> LOG10 = Log10RootFunction.create(0);
    private static final int DISABLED = -1;
    private volatile double estimatedLimit;
    private volatile long rtt_noload = 0L;
    private final int maxLimit;
    private final double smoothing;
    private final Function<Integer, Integer> alphaFunc;
    private final Function<Integer, Integer> betaFunc;
    private final Function<Integer, Integer> thresholdFunc;
    private final Function<Double, Double> increaseFunc;
    private final Function<Double, Double> decreaseFunc;
    private final MetricRegistry.SampleListener rttSampleListener;
    private int probeMultiplier;
    private int probeCountdown;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VegasLimit newDefault() {
        return VegasLimit.newBuilder().build();
    }

    private VegasLimit(Builder builder) {
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.alphaFunc = builder.alphaFunc;
        this.betaFunc = builder.betaFunc;
        this.increaseFunc = builder.increaseFunc;
        this.decreaseFunc = builder.decreaseFunc;
        this.thresholdFunc = builder.thresholdFunc;
        this.smoothing = builder.smoothing;
        this.probeMultiplier = builder.probeMultiplier;
        this.probeCountdown = this.nextProbeCountdown();
        this.rttSampleListener = builder.registry.registerDistribution("min_rtt", new String[0]);
    }

    private int nextProbeCountdown() {
        int max = (int)((double)this.probeMultiplier * this.estimatedLimit);
        return ThreadLocalRandom.current().nextInt(max / 2, max);
    }

    @Override
    public synchronized void update(Limit.SampleWindow sample) {
        long rtt = sample.getCandidateRttNanos();
        Preconditions.checkArgument(rtt > 0L, "rtt must be >0 but got " + rtt);
        if (this.probeCountdown != -1 && this.probeCountdown-- <= 0) {
            LOG.debug("Probe MinRTT {}", (Object)((double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0));
            this.probeCountdown = this.nextProbeCountdown();
            this.rtt_noload = rtt;
            return;
        }
        if (this.rtt_noload == 0L || rtt < this.rtt_noload) {
            LOG.debug("New MinRTT {}", (Object)((double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0));
            this.rtt_noload = rtt;
            return;
        }
        this.rttSampleListener.addSample(this.rtt_noload);
        this.updateEstimatedLimit(sample, rtt);
    }

    private void updateEstimatedLimit(Limit.SampleWindow sample, long rtt) {
        double newLimit;
        int queueSize = (int)Math.ceil(this.estimatedLimit * (1.0 - (double)this.rtt_noload / (double)rtt));
        if (sample.didDrop()) {
            newLimit = this.decreaseFunc.apply(this.estimatedLimit);
        } else {
            if ((double)(sample.getMaxInFlight() * 2) < this.estimatedLimit) {
                return;
            }
            int alpha = this.alphaFunc.apply((int)this.estimatedLimit);
            int beta = this.betaFunc.apply((int)this.estimatedLimit);
            int threshold = this.thresholdFunc.apply((int)this.estimatedLimit);
            if (queueSize <= threshold) {
                newLimit = this.estimatedLimit + (double)beta;
            } else if (queueSize < alpha) {
                newLimit = this.increaseFunc.apply(this.estimatedLimit);
            } else if (queueSize > beta) {
                newLimit = this.decreaseFunc.apply(this.estimatedLimit);
            } else {
                return;
            }
        }
        newLimit = Math.max(1.0, Math.min((double)this.maxLimit, newLimit));
        newLimit = (1.0 - this.smoothing) * this.estimatedLimit + this.smoothing * newLimit;
        if ((int)newLimit != (int)this.estimatedLimit && LOG.isDebugEnabled()) {
            LOG.debug("New limit={} minRtt={} ms winRtt={} ms queueSize={}", new Object[]{(int)newLimit, (double)TimeUnit.NANOSECONDS.toMicros(this.rtt_noload) / 1000.0, (double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0, queueSize});
        }
        this.estimatedLimit = newLimit;
    }

    @Override
    public int getLimit() {
        return (int)this.estimatedLimit;
    }

    public String toString() {
        return "VegasLimit [limit=" + this.getLimit() + ", rtt_noload=" + (double)TimeUnit.NANOSECONDS.toMicros(this.rtt_noload) / 1000.0 + " ms]";
    }

    public static class Builder {
        private int initialLimit = 20;
        private int maxConcurrency = 1000;
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private double smoothing = 1.0;
        private Function<Integer, Integer> alphaFunc = limit -> 3 * (Integer)LOG10.apply(Integer.valueOf(limit));
        private Function<Integer, Integer> betaFunc = limit -> 6 * (Integer)LOG10.apply(Integer.valueOf(limit));
        private Function<Integer, Integer> thresholdFunc = limit -> (Integer)LOG10.apply(Integer.valueOf(limit));
        private Function<Double, Double> increaseFunc = limit -> limit + (double)((Integer)LOG10.apply(limit.intValue())).intValue();
        private Function<Double, Double> decreaseFunc = limit -> limit - (double)((Integer)LOG10.apply(limit.intValue())).intValue();
        private int probeMultiplier = 30;

        private Builder() {
        }

        public Builder probeMultiplier(int probeMultiplier) {
            this.probeMultiplier = probeMultiplier;
            return this;
        }

        public Builder alpha(int alpha) {
            this.alphaFunc = ignore -> alpha;
            return this;
        }

        public Builder threshold(Function<Integer, Integer> threshold) {
            this.thresholdFunc = threshold;
            return this;
        }

        public Builder alpha(Function<Integer, Integer> alpha) {
            this.alphaFunc = alpha;
            return this;
        }

        public Builder beta(int beta) {
            this.betaFunc = ignore -> beta;
            return this;
        }

        public Builder beta(Function<Integer, Integer> beta) {
            this.betaFunc = beta;
            return this;
        }

        public Builder increase(Function<Double, Double> increase) {
            this.increaseFunc = increase;
            return this;
        }

        public Builder decrease(Function<Double, Double> decrease) {
            this.decreaseFunc = decrease;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        @Deprecated
        public Builder tolerance(double tolerance) {
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Deprecated
        public Builder backoffRatio(double ratio) {
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public VegasLimit build() {
            return new VegasLimit(this);
        }
    }
}

