/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.Strategy;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.VegasLimit;
import com.netflix.concurrency.limits.limiter.ImmutableSampleWindow;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class DefaultLimiter<ContextT>
implements Limiter<ContextT> {
    private final Supplier<Long> nanoClock = System::nanoTime;
    private static final long DEFAULT_MIN_WINDOW_TIME = TimeUnit.SECONDS.toNanos(1L);
    private static final long DEFAULT_MAX_WINDOW_TIME = TimeUnit.SECONDS.toNanos(1L);
    private static final int DEFAULT_WINDOW_SIZE = 10;
    private volatile long nextUpdateTime = 0L;
    private final Limit limit;
    private final Strategy<ContextT> strategy;
    private final long minWindowTime;
    private final long maxWindowTime;
    private final int windowSize;
    private final AtomicReference<ImmutableSampleWindow> sample = new AtomicReference<ImmutableSampleWindow>(new ImmutableSampleWindow());
    private final AtomicInteger inFlight = new AtomicInteger();
    private final Object lock = new Object();

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public DefaultLimiter(Limit limit, Strategy<ContextT> strategy) {
        Preconditions.checkArgument(limit != null, "Algorithm may not be null");
        Preconditions.checkArgument(strategy != null, "Strategy may not be null");
        this.limit = limit;
        this.strategy = strategy;
        this.windowSize = 10;
        this.minWindowTime = DEFAULT_MIN_WINDOW_TIME;
        this.maxWindowTime = DEFAULT_MAX_WINDOW_TIME;
        strategy.setLimit(limit.getLimit());
    }

    private DefaultLimiter(Builder builder, Strategy<ContextT> strategy) {
        this.limit = builder.limit;
        this.minWindowTime = builder.minWindowTime;
        this.maxWindowTime = builder.maxWindowTime;
        this.windowSize = builder.windowSize;
        this.strategy = strategy;
        strategy.setLimit(this.limit.getLimit());
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        final Strategy.Token token = this.strategy.tryAcquire(context);
        if (!token.isAcquired()) {
            return Optional.empty();
        }
        final long startTime = this.nanoClock.get();
        final int currentMaxInFlight = this.inFlight.incrementAndGet();
        return Optional.of(new Limiter.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess() {
                DefaultLimiter.this.inFlight.decrementAndGet();
                token.release();
                long endTime = (Long)DefaultLimiter.this.nanoClock.get();
                long rtt = endTime - startTime;
                DefaultLimiter.this.sample.updateAndGet(window -> window.addSample(rtt, currentMaxInFlight));
                if (endTime > DefaultLimiter.this.nextUpdateTime) {
                    Object object = DefaultLimiter.this.lock;
                    synchronized (object) {
                        ImmutableSampleWindow current;
                        if (endTime > DefaultLimiter.this.nextUpdateTime && DefaultLimiter.this.isWindowReady(current = (ImmutableSampleWindow)DefaultLimiter.this.sample.get())) {
                            DefaultLimiter.this.sample.set(new ImmutableSampleWindow());
                            DefaultLimiter.this.nextUpdateTime = endTime + Math.min(Math.max(current.getCandidateRttNanos() * 2L, DefaultLimiter.this.minWindowTime), DefaultLimiter.this.maxWindowTime);
                            DefaultLimiter.this.limit.update(current);
                            DefaultLimiter.this.strategy.setLimit(DefaultLimiter.this.limit.getLimit());
                        }
                    }
                }
            }

            @Override
            public void onIgnore() {
                DefaultLimiter.this.inFlight.decrementAndGet();
                token.release();
            }

            @Override
            public void onDropped() {
                DefaultLimiter.this.inFlight.decrementAndGet();
                token.release();
                DefaultLimiter.this.sample.getAndUpdate(current -> current.addDroppedSample(currentMaxInFlight));
            }
        });
    }

    private boolean isWindowReady(ImmutableSampleWindow sample) {
        return sample.getCandidateRttNanos() < Long.MAX_VALUE && sample.getSampleCount() > this.windowSize;
    }

    protected int getLimit() {
        return this.limit.getLimit();
    }

    public String toString() {
        return "DefaultLimiter [RTT_candidate=" + (double)TimeUnit.NANOSECONDS.toMicros(this.sample.get().getCandidateRttNanos()) / 1000.0 + ", maxInFlight=" + this.inFlight + ", " + this.limit + ", " + this.strategy + "]";
    }

    static /* synthetic */ long access$000() {
        return DEFAULT_MAX_WINDOW_TIME;
    }

    static /* synthetic */ long access$100() {
        return DEFAULT_MIN_WINDOW_TIME;
    }

    public static class Builder {
        private Limit limit = VegasLimit.newDefault();
        private long maxWindowTime = DefaultLimiter.access$000();
        private long minWindowTime = DefaultLimiter.access$100();
        private int windowSize = 10;

        public Builder limit(Limit limit) {
            Preconditions.checkArgument(limit != null, "Algorithm may not be null");
            this.limit = limit;
            return this;
        }

        public Builder minWindowTime(long minWindowTime, TimeUnit units) {
            Preconditions.checkArgument(units.toMillis(minWindowTime) >= 100L, "minWindowTime must be >= 100 ms");
            this.minWindowTime = units.toNanos(minWindowTime);
            return this;
        }

        public Builder maxWindowTime(long maxWindowTime, TimeUnit units) {
            Preconditions.checkArgument(maxWindowTime >= units.toMillis(100L), "minWindowTime must be >= 100 ms");
            this.maxWindowTime = units.toNanos(maxWindowTime);
            return this;
        }

        public Builder windowSize(int windowSize) {
            Preconditions.checkArgument(windowSize >= 10, "Window size must be >= 10");
            this.windowSize = windowSize;
            return this;
        }

        public <ContextT> DefaultLimiter<ContextT> build(Strategy<ContextT> strategy) {
            Preconditions.checkArgument(strategy != null, "Strategy may not be null");
            return new DefaultLimiter(this, strategy);
        }
    }
}

