/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.executors;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.BlockingLimiter;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public final class BlockingAdaptiveExecutor
implements Executor {
    private final Limiter<Void> limiter;
    private final Executor executor;

    public BlockingAdaptiveExecutor(Limiter<Void> limiter) {
        this(limiter, Executors.newCachedThreadPool());
    }

    public BlockingAdaptiveExecutor(Limiter<Void> limiter, Executor executor) {
        this.limiter = BlockingLimiter.wrap(limiter);
        this.executor = executor;
    }

    @Override
    public void execute(Runnable command) {
        Limiter.Listener token = this.limiter.acquire(null).orElseThrow(() -> new RejectedExecutionException());
        this.executor.execute(() -> {
            try {
                command.run();
                token.onSuccess();
            }
            catch (RejectedExecutionException e) {
                token.onDropped();
            }
            catch (Exception e) {
                token.onIgnore();
            }
        });
    }
}

