/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.limit.Measurement;

public class ExpAvgMeasurement
implements Measurement {
    private final double ratio;
    private final double filter;
    private double value;

    public ExpAvgMeasurement(int window, double filter) {
        this.ratio = 1.0 / (double)window;
        this.filter = filter;
        this.value = 0.0;
    }

    @Override
    public Number add(Number sample) {
        this.value = this.value == 0.0 ? sample.doubleValue() : (sample.doubleValue() < this.value ? sample.doubleValue() : (1.0 - this.ratio) * this.value + this.ratio * Math.min(this.value * this.filter, sample.doubleValue()));
        return this.value;
    }

    @Override
    public Number get() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0.0;
    }
}

