/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;
import java.util.concurrent.TimeUnit;

public class ImmutableSampleWindow
implements Limit.SampleWindow {
    final long minRtt;
    final int maxInFlight;
    final int sampleCount;
    final boolean didDrop;

    public ImmutableSampleWindow() {
        this.minRtt = Long.MAX_VALUE;
        this.maxInFlight = 0;
        this.sampleCount = 0;
        this.didDrop = false;
    }

    public ImmutableSampleWindow(long minRtt, int maxInFlight, int sampleCount, boolean didDrop) {
        this.minRtt = minRtt;
        this.maxInFlight = maxInFlight;
        this.sampleCount = sampleCount;
        this.didDrop = didDrop;
    }

    public ImmutableSampleWindow addSample(long rtt, int maxInFlight) {
        return new ImmutableSampleWindow(Math.min(rtt, this.minRtt), Math.max(maxInFlight, this.maxInFlight), this.sampleCount + 1, this.didDrop);
    }

    public ImmutableSampleWindow addDroppedSample(int maxInFlight) {
        return new ImmutableSampleWindow(this.minRtt, Math.max(maxInFlight, this.maxInFlight), this.sampleCount, true);
    }

    @Override
    public long getCandidateRttNanos() {
        return this.minRtt;
    }

    @Override
    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public boolean didDrop() {
        return this.didDrop;
    }

    public String toString() {
        return "ImmutableSample [minRtt=" + (double)TimeUnit.NANOSECONDS.toMicros(this.minRtt) / 1000.0 + ", maxInFlight=" + this.maxInFlight + ", sampleCount=" + this.sampleCount + ", didDrop=" + this.didDrop + "]";
    }
}

