/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingLimitDecorator
implements Limit {
    private static final Logger LOG = LoggerFactory.getLogger(TracingLimitDecorator.class);
    private final Limit delegate;

    public static TracingLimitDecorator wrap(Limit delegate) {
        return new TracingLimitDecorator(delegate);
    }

    public TracingLimitDecorator(Limit delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getLimit() {
        return this.delegate.getLimit();
    }

    @Override
    public void update(Limit.SampleWindow sample) {
        LOG.debug("sampleCount={} maxInFlight={} minRtt={} ms", new Object[]{sample.getSampleCount(), sample.getMaxInFlight(), (double)TimeUnit.NANOSECONDS.toMicros(sample.getCandidateRttNanos()) / 1000.0});
        this.delegate.update(sample);
    }
}

