/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.limit.Measurement;

public class ExpAvgMeasurement
implements Measurement {
    private final int window;
    private final double ratio;
    private final double filter;
    private double value;
    private int count;

    public ExpAvgMeasurement(int window, double filter) {
        this.window = window;
        this.ratio = 1.0 / (double)window;
        this.filter = filter;
        this.value = 0.0;
        this.count = 0;
    }

    @Override
    public Number add(Number sample) {
        if (this.count == 0) {
            this.value = sample.doubleValue();
            this.count = 1;
        } else if (this.count < this.window) {
            ++this.count;
            double tempRatio = 1.0 / (double)this.count;
            this.value = (1.0 - tempRatio) * this.value + tempRatio * Math.min(this.value * this.filter, sample.doubleValue());
        } else {
            this.value = (1.0 - this.ratio) * this.value + this.ratio * Math.min(this.value * this.filter, sample.doubleValue());
        }
        return this.value;
    }

    @Override
    public Number get() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0.0;
        this.count = 0;
    }
}

