/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;

public final class AIMDLimit
implements Limit {
    private volatile int limit;
    private final double backoffRatio;

    public static Builder newBuilder() {
        return new Builder();
    }

    private AIMDLimit(Builder builder) {
        this.limit = builder.initialLimit;
        this.backoffRatio = builder.backoffRatio;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void update(Limit.SampleWindow sample) {
        if (sample.didDrop()) {
            this.limit = Math.max(1, Math.min(this.limit - 1, (int)((double)this.limit * this.backoffRatio)));
        } else if (sample.getMaxInFlight() >= this.limit) {
            ++this.limit;
        }
    }

    public String toString() {
        return "AIMDLimit [limit=" + this.limit + "]";
    }

    public static class Builder {
        private int initialLimit = 10;
        private double backoffRatio = 0.9;

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder backoffRatio(double backoffRatio) {
            this.backoffRatio = backoffRatio;
            return this;
        }

        public AIMDLimit build() {
            return new AIMDLimit(this);
        }
    }
}

