/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.ExpAvgMeasurement;
import com.netflix.concurrency.limits.limit.Measurement;
import com.netflix.concurrency.limits.limit.functions.SquareRootFunction;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GradientLimit
implements Limit {
    private static final Logger LOG = LoggerFactory.getLogger(GradientLimit.class);
    private volatile double estimatedLimit;
    private final Measurement rttNoLoadAccumulator;
    private final double smoothing;
    private final int maxLimit;
    private final int minLimit;
    private final Function<Integer, Integer> queueSize;
    private final long minRttThreshold;
    private final MetricRegistry.SampleListener minRttSampleListener;
    private final MetricRegistry.SampleListener minWindowRttSampleListener;
    private final MetricRegistry.SampleListener queueSizeSampleListener;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static GradientLimit newDefault() {
        return GradientLimit.newBuilder().build();
    }

    private GradientLimit(Builder builder) {
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxLimit;
        this.minLimit = builder.minLimit;
        this.queueSize = builder.queueSize;
        this.smoothing = builder.smoothing;
        this.minRttThreshold = builder.minRttThreshold;
        this.rttNoLoadAccumulator = new ExpAvgMeasurement(builder.noLoadRttWindow, builder.noLoadRttFilter);
        this.minRttSampleListener = builder.registry.registerDistribution("min_rtt", new String[0]);
        this.minWindowRttSampleListener = builder.registry.registerDistribution("min_window_rtt", new String[0]);
        this.queueSizeSampleListener = builder.registry.registerDistribution("queue_size", new String[0]);
    }

    @Override
    public synchronized void update(Limit.SampleWindow sample) {
        Preconditions.checkArgument(sample.getCandidateRttNanos() > 0L, "rtt must be >0 but got " + sample.getCandidateRttNanos());
        long rttSample = sample.getCandidateRttNanos();
        this.minWindowRttSampleListener.addSample(rttSample);
        if (rttSample < this.minRttThreshold) {
            return;
        }
        double queueSize = this.queueSize.apply((int)this.estimatedLimit).intValue();
        this.queueSizeSampleListener.addSample(queueSize);
        double rttNoLoad = this.rttNoLoadAccumulator.add(rttSample).doubleValue();
        double rtt = rttSample;
        this.minRttSampleListener.addSample(rttNoLoad);
        double gradient = rtt < rttNoLoad ? 1.0 : Math.max(0.5, rttNoLoad / rtt);
        double newLimit = sample.didDrop() ? this.estimatedLimit / 2.0 : this.estimatedLimit * gradient + queueSize;
        if ((int)newLimit != (int)this.estimatedLimit) {
            if ((double)sample.getMaxInFlight() < this.estimatedLimit / 2.0) {
                return;
            }
            if (newLimit < this.estimatedLimit) {
                newLimit = (1.0 - this.smoothing) * this.estimatedLimit + this.smoothing * newLimit;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("New limit={} minRtt={} ms winRtt={} ms queueSize={} gradient={}", new Object[]{(int)newLimit, (double)TimeUnit.NANOSECONDS.toMicros((int)rttNoLoad) / 1000.0, (double)TimeUnit.NANOSECONDS.toMicros((int)rtt) / 1000.0, queueSize, gradient});
            }
        }
        this.estimatedLimit = newLimit = Math.max(Math.max((double)this.minLimit, queueSize), Math.min((double)this.maxLimit, newLimit));
    }

    @Override
    public int getLimit() {
        return (int)this.estimatedLimit;
    }

    public long getRttNoLoad() {
        return this.rttNoLoadAccumulator.get().longValue();
    }

    public String toString() {
        return "GradientLimit [limit=" + (int)this.estimatedLimit + ", rtt_noload=" + (double)TimeUnit.MICROSECONDS.toMillis(this.getRttNoLoad()) / 1000.0 + " ms]";
    }

    public static class Builder {
        private int initialLimit = 50;
        private int minLimit = 1;
        private int maxLimit = 1000;
        private long minRttThreshold = TimeUnit.MICROSECONDS.toNanos(1L);
        private double smoothing = 0.1;
        private Function<Integer, Integer> queueSize = SquareRootFunction.create(4);
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private int noLoadRttWindow = 1000;
        private double noLoadRttFilter = 1.1;

        public Builder minRttThreshold(long minRttTreshold, TimeUnit units) {
            this.minRttThreshold = units.toNanos(minRttTreshold);
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder minLimit(int minLimit) {
            this.minLimit = minLimit;
            return this;
        }

        @Deprecated
        public Builder rttTolerance(double rttTolerance) {
            Preconditions.checkArgument(rttTolerance >= 1.0, "Tolerance must be >= 1.0");
            return this;
        }

        @Deprecated
        public Builder maxConcurrency(int maxConcurrency) {
            return this.maxLimit(maxConcurrency);
        }

        public Builder maxLimit(int maxLimit) {
            this.maxLimit = maxLimit;
            return this;
        }

        public Builder queueSize(int queueSize) {
            this.queueSize = ignore -> queueSize;
            return this;
        }

        public Builder queueSize(Function<Integer, Integer> queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        @Deprecated
        public Builder probeMultiplier(int probeMultiplier) {
            return this;
        }

        public Builder noLoadRttWindow(int window) {
            this.noLoadRttWindow = window;
            return this;
        }

        public Builder noLoadRttFilter(double filter) {
            this.noLoadRttFilter = filter;
            return this;
        }

        public GradientLimit build() {
            return new GradientLimit(this);
        }
    }
}

