/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.strategy;

import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.Strategy;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import java.util.concurrent.atomic.AtomicInteger;

public final class SimpleStrategy<T>
implements Strategy<T> {
    private final AtomicInteger busy = new AtomicInteger();
    private volatile int limit = 1;
    private final MetricRegistry.SampleListener inflightMetric;

    public SimpleStrategy() {
        this(EmptyMetricRegistry.INSTANCE);
    }

    public SimpleStrategy(MetricRegistry registry) {
        this.inflightMetric = registry.registerDistribution("inflight", new String[0]);
        registry.registerGauge("limit", this::getLimit, new String[0]);
    }

    @Override
    public Strategy.Token tryAcquire(T context) {
        int currentBusy = this.busy.get();
        if (currentBusy >= this.limit) {
            this.inflightMetric.addSample(currentBusy);
            return Strategy.Token.newNotAcquired(currentBusy);
        }
        int inflight = this.busy.incrementAndGet();
        this.inflightMetric.addSample(inflight);
        return Strategy.Token.newAcquired(inflight, this.busy::decrementAndGet);
    }

    @Override
    public void setLimit(int limit) {
        if (limit < 1) {
            limit = 1;
        }
        this.limit = limit;
    }

    int getLimit() {
        return this.limit;
    }

    int getBusyCount() {
        return this.busy.get();
    }

    public String toString() {
        return "SimpleStrategy [busy=" + this.busy.get() + ", limit=" + this.limit + "]";
    }
}

