/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.limit.Measurement;
import java.util.function.Function;

public class SmoothingMinimumMeasurement
implements Measurement {
    private Double value = 0.0;
    private final double ratio;

    public SmoothingMinimumMeasurement(double smoothing) {
        this.ratio = smoothing;
    }

    @Override
    public boolean add(Number sample) {
        if (this.value == 0.0) {
            this.value = sample.doubleValue();
            return true;
        }
        if (sample.doubleValue() < this.value) {
            this.value = this.value * this.ratio + sample.doubleValue() * (1.0 - this.ratio);
            return true;
        }
        return false;
    }

    @Override
    public Number get() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0.0;
    }

    @Override
    public Number update(Function<Number, Number> func) {
        double newValue = func.apply(this.value).doubleValue();
        this.value = this.value * (1.0 - this.ratio) + newValue * this.ratio;
        return this.value;
    }
}

