/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Strategy;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.VegasLimit;
import com.netflix.concurrency.limits.strategy.LookupPartitionStrategy;
import com.netflix.concurrency.limits.strategy.SimpleStrategy;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractLimiterBuilder<BuilderT extends AbstractLimiterBuilder<BuilderT, ContextT>, ContextT> {
    protected Strategy<ContextT> strategy;
    protected LookupPartitionStrategy.Builder<ContextT> builder;
    protected Limit limit = VegasLimit.newDefault();

    public BuilderT partitionByLookup(Function<ContextT, String> contextToGroup, Consumer<LookupPartitionStrategy.Builder<ContextT>> configurer) {
        Preconditions.checkState(this.strategy == null && this.builder == null, "strategy already set");
        this.builder = LookupPartitionStrategy.newBuilder(contextToGroup);
        configurer.accept(this.builder);
        return this.self();
    }

    public BuilderT strategy(Strategy<ContextT> strategy) {
        Preconditions.checkState(this.strategy == null && this.builder == null, "strategy already set");
        this.strategy = strategy;
        return this.self();
    }

    public BuilderT limit(Limit limit) {
        this.limit = limit;
        return this.self();
    }

    protected Strategy<ContextT> getFinalStrategy() {
        if (this.builder != null) {
            return this.builder.build();
        }
        if (this.strategy != null) {
            return this.strategy;
        }
        return new SimpleStrategy();
    }

    protected abstract BuilderT self();
}

