/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;

public class ImmutableSample
implements Limit.SampleWindow {
    final long minRtt;
    final int maxInFlight;
    final int sampleCount;
    final boolean didDrop;

    public ImmutableSample() {
        this.minRtt = Integer.MAX_VALUE;
        this.maxInFlight = 0;
        this.sampleCount = 0;
        this.didDrop = false;
    }

    public ImmutableSample reset() {
        return new ImmutableSample();
    }

    public ImmutableSample(long minRtt, int maxInFlight, int sampleCount, boolean didDrop) {
        this.minRtt = minRtt;
        this.maxInFlight = maxInFlight;
        this.sampleCount = sampleCount;
        this.didDrop = didDrop;
    }

    public ImmutableSample addSample(long rtt, int maxInFlight) {
        return new ImmutableSample(Math.min(rtt, this.minRtt), Math.max(maxInFlight, this.maxInFlight), this.sampleCount + 1, this.didDrop);
    }

    public ImmutableSample addDroppedSample(int maxInFlight) {
        return new ImmutableSample(this.minRtt, Math.max(maxInFlight, this.maxInFlight), this.sampleCount + 1, true);
    }

    @Override
    public long getCandidateRttNanos() {
        return this.minRtt;
    }

    @Override
    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public boolean didDrop() {
        return this.didDrop;
    }
}

