/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.Strategy;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.VegasLimit;
import com.netflix.concurrency.limits.limiter.ImmutableSample;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class DefaultLimiter<ContextT>
implements Limiter<ContextT> {
    private final Supplier<Long> nanoClock = System::nanoTime;
    private static final long DEFAULT_MIN_WINDOW_TIME = TimeUnit.SECONDS.toNanos(1L);
    private static final int DEFAULT_WINDOW_SIZE = 10;
    private static final int MIN_WINDOW_SAMPLE_COUNT = 10;
    private static final int MIN_WINDOW_MAX_INFLIGHT = 1;
    private final AtomicLong nextUpdateTime = new AtomicLong();
    private final Limit limit;
    private final Strategy<ContextT> strategy;
    private final long minWindowTime;
    private final int windowSize;
    private final AtomicReference<ImmutableSample> sample = new AtomicReference<ImmutableSample>(new ImmutableSample());
    private final AtomicInteger inFlight = new AtomicInteger();

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public DefaultLimiter(Limit limit, Strategy<ContextT> strategy) {
        Preconditions.checkArgument(limit != null, "Algorithm may not be null");
        Preconditions.checkArgument(strategy != null, "Strategy may not be null");
        this.limit = limit;
        this.strategy = strategy;
        this.windowSize = 10;
        this.minWindowTime = DEFAULT_MIN_WINDOW_TIME;
        strategy.setLimit(limit.getLimit());
    }

    private DefaultLimiter(Builder builder, Strategy<ContextT> strategy) {
        this.limit = builder.limit;
        this.minWindowTime = builder.minWindowTime;
        this.windowSize = builder.windowSize;
        this.strategy = strategy;
        strategy.setLimit(this.limit.getLimit());
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        final long startTime = this.nanoClock.get();
        final Strategy.Token token = this.strategy.tryAcquire(context);
        if (!token.isAcquired()) {
            return Optional.empty();
        }
        final int currentMaxInFlight = this.inFlight.incrementAndGet();
        return Optional.of(new Limiter.Listener(){

            @Override
            public void onSuccess() {
                DefaultLimiter.this.inFlight.decrementAndGet();
                token.release();
                long endTime = (Long)DefaultLimiter.this.nanoClock.get();
                long rtt = endTime - startTime;
                DefaultLimiter.this.sample.getAndUpdate(current -> current.addSample(rtt, currentMaxInFlight));
                long updateTime = DefaultLimiter.this.nextUpdateTime.get();
                if (endTime >= updateTime) {
                    ImmutableSample last;
                    long nextUpdate = endTime + Math.max(DefaultLimiter.this.minWindowTime, rtt * (long)DefaultLimiter.this.windowSize);
                    if (DefaultLimiter.this.nextUpdateTime.compareAndSet(updateTime, nextUpdate) && (last = (ImmutableSample)DefaultLimiter.this.sample.getAndUpdate(ImmutableSample::reset)).getCandidateRttNanos() < Integer.MAX_VALUE && last.getSampleCount() > 10 && last.getMaxInFlight() > 1) {
                        DefaultLimiter.this.limit.update(last);
                        DefaultLimiter.this.strategy.setLimit(DefaultLimiter.this.limit.getLimit());
                    }
                }
            }

            @Override
            public void onIgnore() {
                token.release();
            }

            @Override
            public void onDropped() {
                DefaultLimiter.this.inFlight.decrementAndGet();
                token.release();
                DefaultLimiter.this.sample.getAndUpdate(current -> current.addDroppedSample(currentMaxInFlight));
            }
        });
    }

    protected int getLimit() {
        return this.limit.getLimit();
    }

    public String toString() {
        return "DefaultLimiter [RTT_candidate=" + (double)TimeUnit.NANOSECONDS.toMicros(this.sample.get().getCandidateRttNanos()) / 1000.0 + ", maxInFlight=" + this.inFlight + ", " + this.limit + ", " + this.strategy + "]";
    }

    static /* synthetic */ long access$000() {
        return DEFAULT_MIN_WINDOW_TIME;
    }

    public static class Builder {
        private Limit limit = VegasLimit.newDefault();
        private long minWindowTime = DefaultLimiter.access$000();
        private int windowSize = 10;

        public Builder limit(Limit limit) {
            Preconditions.checkArgument(limit != null, "Algorithm may not be null");
            this.limit = limit;
            return this;
        }

        public Builder minWindowTime(long minWindowTime, TimeUnit units) {
            Preconditions.checkArgument(minWindowTime >= units.toMillis(100L), "minWindowTime must be >= 100 ms");
            this.minWindowTime = units.toNanos(minWindowTime);
            return this;
        }

        public Builder windowSize(int windowSize) {
            Preconditions.checkArgument(windowSize >= 10, "Window size must be >= 10");
            this.windowSize = windowSize;
            return this;
        }

        public <ContextT> DefaultLimiter<ContextT> build(Strategy<ContextT> strategy) {
            Preconditions.checkArgument(strategy != null, "Strategy may not be null");
            return new DefaultLimiter(this, strategy);
        }
    }
}

