/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VegasLimit
implements Limit {
    private static final Logger LOG = LoggerFactory.getLogger(VegasLimit.class);
    private volatile double estimatedLimit;
    private volatile long rtt_noload = 0L;
    private final int maxLimit;
    private final double smoothing;
    private final Function<Integer, Integer> alphaFunc;
    private final Function<Integer, Integer> betaFunc;
    private final Function<Double, Double> increaseFunc;
    private final Function<Double, Double> decreaseFunc;
    private final MetricRegistry.SampleListener rttSampleListener;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static VegasLimit newDefault() {
        return VegasLimit.newBuilder().build();
    }

    private VegasLimit(Builder builder) {
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.alphaFunc = builder.alpha;
        this.betaFunc = builder.beta;
        this.increaseFunc = builder.increaseFunc;
        this.decreaseFunc = builder.decreaseFunc;
        this.smoothing = builder.smoothing;
        this.rttSampleListener = builder.registry.registerDistribution("min_rtt", new String[0]);
    }

    @Override
    public synchronized void update(Limit.SampleWindow sample) {
        double newLimit;
        long rtt = sample.getCandidateRttNanos();
        Preconditions.checkArgument(rtt > 0L, "rtt must be >0 but got " + rtt);
        if (this.rtt_noload == 0L || rtt < this.rtt_noload) {
            LOG.debug("New MinRTT {}", (Object)((double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0));
            this.rtt_noload = rtt;
        }
        this.rttSampleListener.addSample(this.rtt_noload);
        int queueSize = (int)Math.ceil(this.estimatedLimit * (1.0 - (double)this.rtt_noload / (double)rtt));
        if (sample.didDrop()) {
            newLimit = this.decreaseFunc.apply(this.estimatedLimit);
        } else {
            if ((double)(sample.getMaxInFlight() + queueSize) < this.estimatedLimit) {
                return;
            }
            int alpha = this.alphaFunc.apply((int)this.estimatedLimit);
            int beta = this.betaFunc.apply((int)this.estimatedLimit);
            if (queueSize < alpha) {
                newLimit = this.increaseFunc.apply(this.estimatedLimit);
            } else if (queueSize > beta) {
                newLimit = this.decreaseFunc.apply(this.estimatedLimit);
            } else {
                return;
            }
        }
        newLimit = Math.max(1.0, Math.min((double)this.maxLimit, newLimit));
        newLimit = (1.0 - this.smoothing) * this.estimatedLimit + this.smoothing * newLimit;
        if ((int)newLimit != (int)this.estimatedLimit && LOG.isDebugEnabled()) {
            LOG.debug("New limit={} minRtt={} ms winRtt={} ms queueSize={}", new Object[]{(int)newLimit, (double)TimeUnit.NANOSECONDS.toMicros(this.rtt_noload) / 1000.0, (double)TimeUnit.NANOSECONDS.toMicros(rtt) / 1000.0, queueSize});
        }
        this.estimatedLimit = newLimit;
    }

    @Override
    public int getLimit() {
        return (int)this.estimatedLimit;
    }

    public String toString() {
        return "VegasLimit [limit=" + this.getLimit() + ", rtt_noload=" + (double)TimeUnit.NANOSECONDS.toMicros(this.rtt_noload) / 1000.0 + " ms]";
    }

    public static class Builder {
        private int initialLimit = 20;
        private int maxConcurrency = 1000;
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;
        private double smoothing = 1.0;
        private Function<Integer, Integer> alpha = limit -> 3;
        private Function<Integer, Integer> beta = limit -> 6;
        private Function<Double, Double> increaseFunc = limit -> limit + 1.0;
        private Function<Double, Double> decreaseFunc = limit -> limit - 1.0;

        public Builder alpha(int alpha) {
            this.alpha = ignore -> alpha;
            return this;
        }

        public Builder alpha(Function<Integer, Integer> alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder beta(int beta) {
            this.beta = ignore -> beta;
            return this;
        }

        public Builder beta(Function<Integer, Integer> beta) {
            this.beta = beta;
            return this;
        }

        public Builder increase(Function<Double, Double> increase) {
            this.increaseFunc = increase;
            return this;
        }

        public Builder decrease(Function<Double, Double> decrease) {
            this.decreaseFunc = decrease;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        @Deprecated
        public Builder tolerance(double tolerance) {
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Deprecated
        public Builder backoffRatio(double ratio) {
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public VegasLimit build() {
            return new VegasLimit(this);
        }
    }
}

