/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;

public final class AIMDLimit
implements Limit {
    private volatile int limit;
    private boolean didDrop = false;
    private final double backoffRatio;

    public static Builder newBuilder() {
        return new Builder();
    }

    private AIMDLimit(Builder builder) {
        this.limit = builder.initialLimit;
        this.backoffRatio = builder.backoffRatio;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public synchronized void update(long rtt) {
        if (this.didDrop) {
            this.didDrop = false;
        } else {
            ++this.limit;
        }
    }

    @Override
    public synchronized void drop() {
        if (!this.didDrop) {
            this.didDrop = true;
            this.limit = Math.max(1, Math.min(this.limit - 1, (int)((double)this.limit * this.backoffRatio)));
        }
    }

    public String toString() {
        return "AIMDLimit [limit=" + this.limit + ", didDrop=" + this.didDrop + "]";
    }

    public static class Builder {
        private int initialLimit = 10;
        private double backoffRatio = 0.9;

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder backoffRatio(double backoffRatio) {
            this.backoffRatio = backoffRatio;
            return this;
        }

        public AIMDLimit build() {
            return new AIMDLimit(this);
        }
    }
}

