/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.Strategy;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.VegasLimit;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public final class DefaultLimiter<ContextT>
implements Limiter<ContextT> {
    private final Supplier<Long> nanoClock = System::nanoTime;
    private static final long DEFAULT_MIN_WINDOW_TIME = TimeUnit.SECONDS.toNanos(1L);
    private static final int DEFAULT_WINDOW_SIZE = 10;
    private volatile long RTT_noload = Long.MAX_VALUE;
    private final AtomicLong RTT_candidate = new AtomicLong(Integer.MAX_VALUE);
    private volatile int maxInFlight = 0;
    private final AtomicLong nextUpdateTime = new AtomicLong();
    private final Limit limit;
    private final Strategy<ContextT> strategy;
    private final long minWindowTime;
    private final int windowSize;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public DefaultLimiter(Limit limit, Strategy<ContextT> strategy) {
        Preconditions.checkArgument(limit != null, "Algorithm may not be null");
        Preconditions.checkArgument(strategy != null, "Strategy may not be null");
        this.limit = limit;
        this.strategy = strategy;
        this.windowSize = 10;
        this.minWindowTime = DEFAULT_MIN_WINDOW_TIME;
        strategy.setLimit(limit.getLimit());
    }

    private DefaultLimiter(Builder builder, Strategy<ContextT> strategy) {
        this.limit = builder.limit;
        this.minWindowTime = builder.minWindowTime;
        this.windowSize = builder.windowSize;
        this.strategy = strategy;
        strategy.setLimit(this.limit.getLimit());
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        final long startTime = this.nanoClock.get();
        final Strategy.Token token = this.strategy.tryAcquire(context);
        this.maxInFlight = Math.max(this.maxInFlight, token.getInFlightCount());
        if (!token.isAcquired()) {
            return Optional.empty();
        }
        return Optional.of(new Limiter.Listener(){

            @Override
            public void onSuccess() {
                long updateTime;
                long current;
                token.release();
                long endTime = (Long)DefaultLimiter.this.nanoClock.get();
                long rtt = endTime - startTime;
                if (rtt < DefaultLimiter.this.RTT_noload) {
                    DefaultLimiter.this.RTT_noload = rtt;
                }
                if (rtt < (current = DefaultLimiter.this.RTT_candidate.get())) {
                    DefaultLimiter.this.RTT_candidate.compareAndSet(current, rtt);
                    current = rtt;
                }
                if (endTime >= (updateTime = DefaultLimiter.this.nextUpdateTime.get()) && DefaultLimiter.this.nextUpdateTime.compareAndSet(updateTime, endTime + Math.max(DefaultLimiter.this.minWindowTime, DefaultLimiter.this.RTT_noload * (long)DefaultLimiter.this.windowSize)) && current != Integer.MAX_VALUE && DefaultLimiter.this.RTT_candidate.compareAndSet(current, Integer.MAX_VALUE)) {
                    DefaultLimiter.this.limit.update(current, DefaultLimiter.this.maxInFlight);
                    DefaultLimiter.this.strategy.setLimit(DefaultLimiter.this.limit.getLimit());
                    DefaultLimiter.this.maxInFlight = 0;
                }
            }

            @Override
            public void onIgnore() {
                token.release();
            }

            @Override
            public void onDropped() {
                token.release();
                DefaultLimiter.this.limit.drop();
            }
        });
    }

    protected int getLimit() {
        return this.limit.getLimit();
    }

    protected long getMinRtt() {
        return this.RTT_noload == Long.MAX_VALUE ? 0L : this.RTT_noload;
    }

    public String toString() {
        return "DefaultLimiter [RTT_noload=" + TimeUnit.NANOSECONDS.toMillis(this.getMinRtt()) + ", RTT_candidate=" + TimeUnit.NANOSECONDS.toMillis(this.RTT_candidate.get()) + ", maxInFlight=" + this.maxInFlight + ", " + this.limit + ", " + this.strategy + "]";
    }

    static /* synthetic */ long access$000() {
        return DEFAULT_MIN_WINDOW_TIME;
    }

    public static class Builder {
        private Limit limit = VegasLimit.newDefault();
        private long minWindowTime = DefaultLimiter.access$000();
        private int windowSize = 10;

        public Builder limit(Limit limit) {
            Preconditions.checkArgument(limit != null, "Algorithm may not be null");
            this.limit = limit;
            return this;
        }

        public Builder minWindowTime(long minWindowTime, TimeUnit units) {
            Preconditions.checkArgument(minWindowTime >= units.toMillis(100L), "minWindowTime must be >= 100 ms");
            this.minWindowTime = units.toNanos(minWindowTime);
            return this;
        }

        public Builder windowSize(int windowSize) {
            Preconditions.checkArgument(windowSize >= 10, "Window size must be >= 10");
            this.windowSize = windowSize;
            return this;
        }

        public <ContextT> DefaultLimiter<ContextT> build(Strategy<ContextT> strategy) {
            Preconditions.checkArgument(strategy != null, "Strategy may not be null");
            return new DefaultLimiter(this, strategy);
        }
    }
}

