/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.Strategy;
import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limiter.DefaultLimiter;
import com.netflix.concurrency.limits.strategy.LookupPartitionStrategy;
import com.netflix.concurrency.limits.strategy.SimpleStrategy;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractLimiterBuilder<BuilderT extends AbstractLimiterBuilder<BuilderT, ContextT>, ContextT> {
    protected Strategy<ContextT> strategy;
    protected LookupPartitionStrategy.Builder<ContextT> builder;
    private DefaultLimiter.Builder limiterBuilder = DefaultLimiter.newBuilder();

    public BuilderT partitionByLookup(Function<ContextT, String> contextToGroup, Consumer<LookupPartitionStrategy.Builder<ContextT>> configurer) {
        Preconditions.checkState(this.strategy == null && this.builder == null, "strategy already set");
        this.builder = LookupPartitionStrategy.newBuilder(contextToGroup);
        configurer.accept(this.builder);
        return this.self();
    }

    public BuilderT strategy(Strategy<ContextT> strategy) {
        Preconditions.checkState(this.strategy == null && this.builder == null, "strategy already set");
        this.strategy = strategy;
        return this.self();
    }

    @Deprecated
    public BuilderT limit(Limit limit) {
        return this.limiter(builder -> builder.limit(limit));
    }

    public BuilderT limiter(Consumer<DefaultLimiter.Builder> consumer) {
        consumer.accept(this.limiterBuilder);
        return this.self();
    }

    protected Limiter<ContextT> buildLimiter() {
        return this.limiterBuilder.build(this.getFinalStrategy());
    }

    private Strategy<ContextT> getFinalStrategy() {
        if (this.builder != null) {
            return this.builder.build();
        }
        if (this.strategy != null) {
            return this.strategy;
        }
        return new SimpleStrategy();
    }

    protected abstract BuilderT self();
}

