/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.internal.EmptyMetricRegistry;
import com.netflix.concurrency.limits.internal.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GradientLimit
implements Limit {
    private static final Logger LOG = LoggerFactory.getLogger(GradientLimit.class);
    private volatile double estimatedLimit;
    private volatile long rtt_noload = 0L;
    private boolean didDrop = false;
    private final int maxLimit;
    private final Function<Integer, Integer> queueSize;
    private final double smoothing;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static GradientLimit newDefault() {
        return GradientLimit.newBuilder().build();
    }

    private GradientLimit(Builder builder) {
        this.estimatedLimit = builder.initialLimit;
        this.maxLimit = builder.maxConcurrency;
        this.queueSize = builder.queueSize;
        this.smoothing = builder.smoothing;
    }

    @Override
    public synchronized void update(long rtt) {
        double newLimit;
        Preconditions.checkArgument(rtt > 0L, "rtt must be >0 but got " + rtt);
        if (this.rtt_noload == 0L || rtt < this.rtt_noload) {
            LOG.debug("New MinRTT {}", (Object)rtt);
            this.rtt_noload = rtt;
        }
        double queueSize = this.queueSize.apply((int)Math.ceil(this.estimatedLimit)).intValue();
        double gradient = (double)this.rtt_noload / (double)rtt;
        if (this.didDrop) {
            newLimit = this.estimatedLimit * (1.0 - this.smoothing) + this.smoothing * (this.estimatedLimit / 2.0);
            this.didDrop = false;
        } else {
            newLimit = this.estimatedLimit * (1.0 - this.smoothing) + this.smoothing * (gradient * this.estimatedLimit + queueSize);
        }
        newLimit = Math.max(1.0, Math.min((double)this.maxLimit, newLimit));
        if ((int)newLimit != (int)this.estimatedLimit) {
            this.estimatedLimit = newLimit;
            if (LOG.isDebugEnabled()) {
                LOG.debug("New limit={} minRtt={} \u03bcs winRtt={} \u03bcs queueSize={} gradient={}", new Object[]{(int)this.estimatedLimit, TimeUnit.NANOSECONDS.toMicros(this.rtt_noload), TimeUnit.NANOSECONDS.toMicros(rtt), queueSize, gradient});
            }
        }
    }

    @Override
    public synchronized void drop() {
        this.didDrop = true;
    }

    @Override
    public int getLimit() {
        return (int)Math.ceil(this.estimatedLimit);
    }

    public long getRttNoLoad() {
        return this.rtt_noload;
    }

    public String toString() {
        return "GradientLimit [limit=" + (int)this.estimatedLimit + ", rtt_noload=" + TimeUnit.NANOSECONDS.toMillis(this.rtt_noload) + "]";
    }

    public static class Builder {
        private int initialLimit = 20;
        private int maxConcurrency = 1000;
        private double smoothing = 0.2;
        private Function<Integer, Integer> queueSize = limit -> (int)Math.max(4.0, Math.sqrt(limit.intValue()));
        private MetricRegistry registry = EmptyMetricRegistry.INSTANCE;

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder maxConcurrency(int maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder queueSize(int queueSize) {
            this.queueSize = ignore -> queueSize;
            return this;
        }

        public Builder queueSize(Function<Integer, Integer> queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public Builder smoothing(double smoothing) {
            this.smoothing = smoothing;
            return this;
        }

        public Builder metricRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public GradientLimit build() {
            GradientLimit limit = new GradientLimit(this);
            this.registry.registerGauge("min_rtt", limit::getRttNoLoad, new String[0]);
            return limit;
        }
    }
}

