/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.logging.log4jAdapter;

import com.netflix.blitz4j.LoggingContext;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class NFPatternParser
extends PatternParser {
    private static List<Character> contextCharList = Arrays.asList(Character.valueOf('c'), Character.valueOf('l'), Character.valueOf('M'), Character.valueOf('C'), Character.valueOf('L'), Character.valueOf('F'));

    public NFPatternParser(String pattern) {
        super(pattern);
    }

    protected void finalizeConverter(char c) {
        if (contextCharList.contains(Character.valueOf(c))) {
            NFPatternConverter pc = new NFPatternConverter(this.formattingInfo, c);
            this.addConverter(pc);
            this.currentLiteral.setLength(0);
        } else {
            super.finalizeConverter(c);
        }
    }

    private static class NFPatternConverter
    extends PatternConverter {
        private char type;

        NFPatternConverter(FormattingInfo formattingInfo, char type) {
            super(formattingInfo);
            this.type = type;
        }

        public String convert(LoggingEvent event) {
            LoggingContext.getInstance().shouldGenerateLocationInfo(event.getLogger());
            LocationInfo locationInfo = LoggingContext.getInstance().getLocationInfo(event);
            if (locationInfo == null) {
                return "";
            }
            switch (this.type) {
                case 'M': {
                    return locationInfo.getMethodName();
                }
                case 'c': {
                    return event.getLoggerName();
                }
                case 'C': {
                    return locationInfo.getClassName();
                }
                case 'L': {
                    return locationInfo.getLineNumber();
                }
                case 'l': {
                    return locationInfo.getFileName() + ":" + locationInfo.getClassName() + " " + locationInfo.getLineNumber() + " " + locationInfo.getMethodName();
                }
                case 'F': {
                    return locationInfo.getFileName();
                }
            }
            return "";
        }
    }
}

