/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import com.netflix.blitz4j.LoggingContext;
import com.netflix.blitz4j.NFAppenderAttachableImpl;
import com.netflix.blitz4j.NFHierarchy;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggingEvent;

public class NFLockFreeLogger
extends Logger {
    AppenderAttachableImpl aai;
    private LoggingContext loggingContext = LoggingContext.getInstance();

    protected NFLockFreeLogger(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender newAppender) {
        if (this.aai == null) {
            NFLockFreeLogger nFLockFreeLogger = this;
            synchronized (nFLockFreeLogger) {
                if (this.aai == null) {
                    this.aai = new NFAppenderAttachableImpl();
                }
            }
        }
        this.aai.addAppender(newAppender);
        this.repository.fireAddAppenderEvent((Category)this, newAppender);
    }

    public void callAppenders(LoggingEvent event) {
        int writes = 0;
        for (NFLockFreeLogger c = this; c != null; c = c.getParent()) {
            if (!NFLockFreeLogger.class.isInstance((Object)c)) continue;
            if (c.aai != null) {
                int appenderWrite = c.aai.appendLoopOnAppenders(event);
                writes += appenderWrite;
            }
            if (!c.getAdditivity()) break;
        }
        if (writes == 0) {
            this.repository.emitNoAppenderWarning((Category)this);
        }
    }

    public Enumeration getAllAppenders() {
        if (this.aai == null) {
            return NullEnumeration.getInstance();
        }
        return this.aai.getAllAppenders();
    }

    public Appender getAppender(String name) {
        if (this.aai == null || name == null) {
            return null;
        }
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender appender) {
        if (appender == null || this.aai == null) {
            return false;
        }
        return this.aai.isAttached(appender);
    }

    public void removeAllAppenders() {
        if (this.aai != null) {
            Vector appenders = new Vector();
            Enumeration iter = this.aai.getAllAppenders();
            if (iter == null) {
                return;
            }
            while (iter.hasMoreElements()) {
                appenders.add(iter.nextElement());
            }
            this.aai.removeAllAppenders();
            iter = appenders.elements();
            while (iter.hasMoreElements()) {
                this.fireRemoveAppenderEvent((Appender)iter.nextElement());
            }
        }
    }

    public Level getEffectiveLevel() {
        if (this.loggingContext == null) {
            return super.getEffectiveLevel();
        }
        if (this.loggingContext.getContextLevel() != null) {
            return this.loggingContext.getContextLevel();
        }
        return super.getEffectiveLevel();
    }

    public void removeAppender(Appender appender) {
        if (appender == null || this.aai == null) {
            return;
        }
        boolean wasAttached = this.aai.isAttached(appender);
        this.aai.removeAppender(appender);
        if (wasAttached) {
            this.fireRemoveAppenderEvent(appender);
        }
    }

    public void removeAppender(String name) {
        if (name == null || this.aai == null) {
            return;
        }
        Appender appender = this.aai.getAppender(name);
        this.aai.removeAppender(name);
        if (appender != null) {
            this.fireRemoveAppenderEvent(appender);
        }
    }

    public void reconcileAppenders() {
        if (this.aai != null) {
            ((NFAppenderAttachableImpl)this.aai).reconcileAppenders();
        }
    }

    private void fireRemoveAppenderEvent(Appender appender) {
        if (appender != null) {
            if (this.repository instanceof Hierarchy) {
                ((NFHierarchy)this.repository).fireRemoveAppenderEvent((Category)this, appender);
            } else if (this.repository instanceof HierarchyEventListener) {
                ((HierarchyEventListener)this.repository).removeAppenderEvent((Category)this, appender);
            }
        }
    }
}

