/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.blitz4j.AsyncAppender;
import com.netflix.blitz4j.BlitzConfig;
import com.netflix.blitz4j.DefaultBlitz4jConfig;
import com.netflix.blitz4j.LoggerCache;
import com.netflix.blitz4j.NFHierarchy;
import com.netflix.blitz4j.NFLockFreeLogger;
import com.netflix.blitz4j.NFRepositorySelector;
import com.netflix.blitz4j.NFRootLogger;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.ExpandedConfigurationListenerAdapter;
import com.netflix.config.PropertyListener;
import com.netflix.logging.messaging.BatcherFactory;
import com.netflix.logging.messaging.MessageBatcher;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.slf4j.Logger;

public class LoggingConfiguration
implements PropertyListener {
    private static final String LOG4J_ROOT_LOGGER = "log4j.rootLogger";
    private static final String LOG4J_ROOT_CATEGORY = "log4j.rootCategory";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String BLITZ_LOGGER_FACTORY = "com.netflix.blitz4j.NFCategoryFactory";
    private static final String PROP_LOG4J_CONFIGURATION = "log4j.configuration";
    private static final Object guard = new Object();
    private static final String PROP_LOG4J_LOGGER_FACTORY = "log4j.loggerFactory";
    private static final String LOG4J_FACTORY_IMPL = "com.netflix.logging.log4jAdapter.NFCategoryFactory";
    private static final String LOG4J_LOGGER_FACTORY = "log4j.loggerFactory";
    private static final String PROP_LOG4J_ORIGINAL_APPENDER_NAME = "originalAppenderName";
    private static final String LOG4J_PREFIX = "log4j.logger";
    private static final String LOG4J_APPENDER_DELIMITER = ".";
    private static final String LOG4J_APPENDER_PREFIX = "log4j.appender";
    private static final String ASYNC_APPENDERNAME_SUFFIX = "_ASYNC";
    private static final String ROOT_CATEGORY = "rootCategory";
    private static final String ROOT_LOGGER = "rootLogger";
    private Map<String, String> originalAsyncAppenderNameMap = new HashMap<String, String>();
    private BlitzConfig blitz4jConfig;
    private Properties initialProps = new Properties();
    private Properties overrideProps = new Properties();
    private final ExecutorService executorPool;
    private final AtomicInteger pendingRefreshes = new AtomicInteger();
    private final AtomicInteger refreshCount = new AtomicInteger();
    private Logger logger;
    private static final int MIN_DELAY_BETWEEN_REFRESHES = 200;
    private static final CharSequence PROP_LOG4J_ASYNC_APPENDERS = "log4j.logger.asyncAppenders";
    private static LoggingConfiguration instance = new LoggingConfiguration();

    protected LoggingConfiguration() {
        this.executorPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("DynamicLog4jListener").build());
    }

    public void configure() {
        this.configure(new Properties());
    }

    public void configure(Properties props) {
        block27: {
            String log4jLoggerFactory;
            this.refreshCount.set(0);
            this.overrideProps.clear();
            this.originalAsyncAppenderNameMap.clear();
            String log4jConfigurationFile = System.getProperty(PROP_LOG4J_CONFIGURATION);
            NFHierarchy nfHierarchy = null;
            if (!NFHierarchy.class.equals(LogManager.getLoggerRepository().getClass())) {
                nfHierarchy = new NFHierarchy(new NFRootLogger(Level.INFO));
                LogManager.setRepositorySelector((RepositorySelector)new NFRepositorySelector((LoggerRepository)nfHierarchy), (Object)guard);
            }
            if ((log4jLoggerFactory = System.getProperty("log4j.loggerFactory")) != null) {
                this.initialProps.setProperty("log4j.loggerFactory", log4jLoggerFactory);
                if (nfHierarchy != null) {
                    try {
                        LoggerFactory loggerFactory = (LoggerFactory)Class.forName(log4jLoggerFactory).newInstance();
                        nfHierarchy.setLoggerFactory(loggerFactory);
                    }
                    catch (Exception e) {
                        System.err.println("Cannot set the logger factory. Hence reverting to default.");
                        e.printStackTrace();
                    }
                }
            } else {
                this.initialProps.setProperty("log4j.loggerFactory", BLITZ_LOGGER_FACTORY);
            }
            if (log4jConfigurationFile != null) {
                this.loadLog4jConfigurationFile(log4jConfigurationFile);
                this.clearAsyncAppenderList();
                PropertyConfigurator.configure((Properties)this.initialProps);
            }
            this.blitz4jConfig = new DefaultBlitz4jConfig(props);
            if (log4jConfigurationFile == null && this.blitz4jConfig.shouldLoadLog4jPropertiesFromClassPath()) {
                try {
                    URL url = Loader.getResource((String)LOG4J_PROPERTIES);
                    if (url == null) break block27;
                    try (InputStream in = url.openStream();){
                        this.initialProps.load(in);
                    }
                }
                catch (Exception t) {
                    System.err.println("Error loading properties from log4j.properties");
                }
            }
        }
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String propertyValue = props.getProperty(key);
            this.initialProps.setProperty(key, propertyValue);
        }
        this.blitz4jConfig = new DefaultBlitz4jConfig(this.initialProps);
        String[] asyncAppenderArray = this.blitz4jConfig.getAsyncAppenders();
        if (asyncAppenderArray == null) {
            return;
        }
        for (int i = 0; i < asyncAppenderArray.length; ++i) {
            String oneAppenderName = asyncAppenderArray[i];
            if (i == 0 || oneAppenderName == null) continue;
            oneAppenderName = oneAppenderName.trim();
            String oneAsyncAppenderName = oneAppenderName + ASYNC_APPENDERNAME_SUFFIX;
            this.originalAsyncAppenderNameMap.put(oneAppenderName, oneAsyncAppenderName);
        }
        try {
            this.convertConfiguredAppendersToAsync(this.initialProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not configure async appenders ", e);
        }
        this.blitz4jConfig = new DefaultBlitz4jConfig(this.initialProps);
        this.clearAsyncAppenderList();
        PropertyConfigurator.configure((Properties)this.initialProps);
        this.closeNonexistingAsyncAppenders();
        this.logger = org.slf4j.LoggerFactory.getLogger(LoggingConfiguration.class);
        ConfigurationManager.getConfigInstance().addConfigurationListener((ConfigurationListener)new ExpandedConfigurationListenerAdapter((PropertyListener)this));
    }

    private void clearAsyncAppenderList() {
        org.apache.log4j.Logger asyncLogger = LoggerCache.getInstance().getOrCreateLogger("asyncAppenders");
        if (asyncLogger != null) {
            asyncLogger.removeAllAppenders();
        }
    }

    private void loadLog4jConfigurationFile(String log4jConfigurationFile) {
        try {
            URL url = new URL(log4jConfigurationFile);
            try (InputStream in = url.openStream();){
                this.initialProps.load(in);
            }
        }
        catch (Exception t) {
            throw new RuntimeException("Cannot load log4 configuration file specified in log4j.configuration", t);
        }
    }

    public static LoggingConfiguration getInstance() {
        return instance;
    }

    public BlitzConfig getConfiguration() {
        return this.blitz4jConfig;
    }

    public Properties getInitialProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.initialProps);
        return props;
    }

    public Properties getOverrideProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.overrideProps);
        return props;
    }

    public int getRefreshCount() {
        return this.refreshCount.get();
    }

    public void stop() {
        String batcherName;
        MessageBatcher batcher = null;
        for (String originalAppenderName : this.originalAsyncAppenderNameMap.keySet()) {
            batcherName = AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName;
            batcher = BatcherFactory.getBatcher(batcherName);
            if (batcher == null) continue;
            batcher.stop();
        }
        for (String originalAppenderName : this.originalAsyncAppenderNameMap.keySet()) {
            batcherName = AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName;
            batcher = BatcherFactory.getBatcher(batcherName);
            if (batcher == null) continue;
            BatcherFactory.removeBatcher(batcherName);
        }
    }

    public synchronized void addProperty(Object source, String name, Object value, boolean beforeUpdate) {
        if (!beforeUpdate && this.isLog4JProperty(name)) {
            this.overrideProps.put(name, value);
            this.reConfigureAsynchronously();
        }
    }

    public void clear(Object source, boolean beforeUpdate) {
    }

    public synchronized void clearProperty(Object source, String name, Object value, boolean beforeUpdate) {
        if (!beforeUpdate && this.isLog4JProperty(name)) {
            this.overrideProps.remove(name);
            this.reConfigureAsynchronously();
        }
    }

    public void configSourceLoaded(Object source) {
        Properties props = ConfigurationConverter.getProperties((Configuration)ConfigurationManager.getConfigInstance());
        this.reconfigure(props);
    }

    public synchronized void setProperty(Object source, String name, Object value, boolean beforeUpdate) {
        if (!beforeUpdate && this.isLog4JProperty(name)) {
            this.overrideProps.put(name, value);
            this.reConfigureAsynchronously();
        }
    }

    public synchronized void reconfigure(Properties props) {
        Properties newOverrideProps = new Properties();
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            Object initialValue;
            if (!this.isLog4JProperty(prop.getKey().toString()) || (initialValue = this.initialProps.get(prop.getKey())) != null && initialValue.equals(prop.getValue())) continue;
            newOverrideProps.put(prop.getKey(), prop.getValue());
        }
        if (!this.overrideProps.equals(newOverrideProps)) {
            this.overrideProps.clear();
            this.overrideProps.putAll((Map<?, ?>)newOverrideProps);
            this.reConfigureAsynchronously();
        }
    }

    private void reConfigureAsynchronously() {
        this.refreshCount.incrementAndGet();
        if (this.pendingRefreshes.incrementAndGet() == 1) {
            this.executorPool.submit(new Runnable(){

                @Override
                public void run() {
                    do {
                        try {
                            Thread.sleep(200L);
                            LoggingConfiguration.this.logger.info("Configuring log4j dynamically");
                            LoggingConfiguration.this.reconfigure();
                        }
                        catch (Exception th) {
                            LoggingConfiguration.this.logger.error("Cannot dynamically configure log4j :", (Throwable)th);
                        }
                    } while (0 != LoggingConfiguration.this.pendingRefreshes.getAndSet(0));
                }
            });
        }
    }

    private synchronized Properties getConsolidatedProperties() {
        this.logger.info("Override properties are :" + this.overrideProps);
        Properties consolidatedProps = new Properties();
        consolidatedProps.putAll((Map<?, ?>)this.initialProps);
        consolidatedProps.putAll((Map<?, ?>)this.overrideProps);
        return consolidatedProps;
    }

    private void reconfigure() throws ConfigurationException, FileNotFoundException {
        MessageBatcher asyncBatcher;
        Properties consolidatedProps = this.getConsolidatedProperties();
        this.logger.info("The root category for log4j.rootCategory now is {}", (Object)consolidatedProps.getProperty(LOG4J_ROOT_CATEGORY));
        this.logger.info("The root category for log4j.rootLogger now is {}", (Object)consolidatedProps.getProperty(LOG4J_ROOT_LOGGER));
        for (String originalAppenderName : this.originalAsyncAppenderNameMap.keySet()) {
            asyncBatcher = BatcherFactory.getBatcher(AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName);
            if (asyncBatcher == null) continue;
            asyncBatcher.pause();
        }
        this.configureLog4j(consolidatedProps);
        for (String originalAppenderName : this.originalAsyncAppenderNameMap.keySet()) {
            asyncBatcher = BatcherFactory.getBatcher(AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName);
            if (asyncBatcher == null) continue;
            asyncBatcher.resume();
        }
    }

    private void configureLog4j(Properties props) throws ConfigurationException, FileNotFoundException {
        if (this.blitz4jConfig.shouldUseLockFree() && props.getProperty("log4j.loggerFactory") == null) {
            props.setProperty("log4j.loggerFactory", LOG4J_FACTORY_IMPL);
        }
        this.convertConfiguredAppendersToAsync(props);
        this.clearAsyncAppenderList();
        this.logger.info("Configuring log4j with properties :" + props);
        PropertyConfigurator.configure((Properties)props);
    }

    private boolean isLog4JProperty(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(LOG4J_PREFIX);
    }

    private void convertConfiguredAppendersToAsync(Properties props) throws ConfigurationException, FileNotFoundException {
        for (Map.Entry<String, String> originalAsyncAppenderMapEntry : this.originalAsyncAppenderNameMap.entrySet()) {
            String asyncAppenderName = originalAsyncAppenderMapEntry.getValue();
            props.setProperty("log4j.appender." + asyncAppenderName, AsyncAppender.class.getName());
            String originalAppenderName = originalAsyncAppenderMapEntry.getKey();
            props.setProperty("log4j.appender." + asyncAppenderName + LOG4J_APPENDER_DELIMITER + PROP_LOG4J_ORIGINAL_APPENDER_NAME, originalAppenderName);
            this.initialProps.setProperty("batcher." + AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName + ".rejectWhenFull", "true");
            String maxThreads = this.initialProps.getProperty("batcher." + AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName + ".maxThreads");
            if (maxThreads == null) {
                this.initialProps.setProperty("batcher." + AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName + ".maxThreads", "1");
            }
            for (Map.Entry<Object, Object> mapEntry : props.entrySet()) {
                Object value;
                String key = mapEntry.getKey().toString();
                if (!key.contains(LOG4J_PREFIX) && !key.contains(ROOT_CATEGORY) && !key.contains(ROOT_LOGGER) || key.contains(PROP_LOG4J_ASYNC_APPENDERS) || key.contains(PROP_LOG4J_ORIGINAL_APPENDER_NAME) || (value = mapEntry.getValue()) == null) continue;
                String[] values = ((String)String.class.cast(value)).split(",");
                String valueString = "";
                int ctr = 0;
                for (String oneValue : values) {
                    if (oneValue == null) continue;
                    ++ctr;
                    if (originalAppenderName.equals(oneValue.trim())) {
                        oneValue = asyncAppenderName;
                    }
                    valueString = ctr != values.length ? valueString + oneValue + "," : valueString + oneValue;
                }
                mapEntry.setValue(valueString);
            }
        }
    }

    private void closeNonexistingAsyncAppenders() {
        org.apache.log4j.Logger rootLogger = LogManager.getRootLogger();
        if (NFLockFreeLogger.class.isInstance(rootLogger)) {
            ((NFLockFreeLogger)rootLogger).reconcileAppenders();
        }
        Enumeration enums = LogManager.getCurrentLoggers();
        while (enums.hasMoreElements()) {
            Object myLogger = enums.nextElement();
            if (!NFLockFreeLogger.class.isInstance(myLogger)) continue;
            ((NFLockFreeLogger)((Object)myLogger)).reconcileAppenders();
        }
    }
}

