/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.logging.messaging;

import com.netflix.logging.messaging.MessageBatcher;
import com.netflix.logging.messaging.MessageProcessor;
import java.util.HashMap;
import java.util.Map;

public class BatcherFactory {
    private static BatcherFactory batcherFactory = new BatcherFactory();
    private static Map<String, MessageBatcher> batcherMap = new HashMap<String, MessageBatcher>();

    public static MessageBatcher getBatcher(String name) {
        MessageBatcher batcher = batcherMap.get(name);
        return batcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageBatcher createBatcher(String name, MessageProcessor processor) {
        MessageBatcher batcher = batcherMap.get(name);
        if (batcher != null) return batcher;
        Class<BatcherFactory> clazz = BatcherFactory.class;
        synchronized (BatcherFactory.class) {
            batcher = batcherMap.get(name);
            if (batcher != null) return batcher;
            batcher = new MessageBatcher(name, processor);
            batcherMap.put(name, batcher);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return batcher;
        }
    }

    public static void removeBatcher(String name) {
        batcherMap.remove(name);
    }
}

