/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.blitz4j.AsyncAppender;
import com.netflix.blitz4j.BlitzConfig;
import com.netflix.blitz4j.DefaultBlitz4jConfig;
import com.netflix.blitz4j.NFHierarchy;
import com.netflix.blitz4j.NFLockFreeLogger;
import com.netflix.blitz4j.NFRepositorySelector;
import com.netflix.blitz4j.NFRootLogger;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.ExpandedConfigurationListenerAdapter;
import com.netflix.config.PropertyListener;
import com.netflix.logging.messaging.BatcherFactory;
import com.netflix.logging.messaging.MessageBatcher;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.slf4j.Logger;

public class LoggingConfiguration
implements PropertyListener {
    private static final String BLITZ_LOGGER_FACTORY = "com.netflix.blitz4j.NFCategoryFactory";
    private static final String PROP_LOG4J_CONFIGURATION = "log4j.configuration";
    private static final Object guard = new Object();
    private static final String PROP_LOG4J_LOGGER_FACTORY = "log4j.loggerFactory";
    private static final String LOG4J_FACTORY_IMPL = "com.netflix.logging.log4jAdapter.NFCategoryFactory";
    private static final String LOG4J_LOGGER_FACTORY = "log4j.loggerFactory";
    private static final String PROP_LOG4J_ORIGINAL_APPENDER_NAME = "originalAppenderName";
    private static final String LOG4J_PREFIX = "log4j.logger";
    private static final String LOG4J_APPENDER_DELIMITER = ".";
    private static final String LOG4J_APPENDER_PREFIX = "log4j.appender";
    private static final String ASYNC_APPENDERNAME_SUFFIX = "_ASYNC";
    private static final String ROOT_CATEGORY = "rootCategory";
    private static final String ROOT_LOGGER = "rootLogger";
    private Map<String, String> originalAsyncAppenderNameMap = new HashMap<String, String>();
    private BlitzConfig blitz4jConfig;
    private Properties props = new Properties();
    Properties updatedProps = new Properties();
    private final ExecutorService executorPool;
    private Logger logger;
    private static final int SLEEP_TIME_MS = 200;
    private static final CharSequence PROP_LOG4J_ASYNC_APPENDERS = "log4j.logger.asyncAppenders";
    private static LoggingConfiguration instance = new LoggingConfiguration();

    private LoggingConfiguration() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(false).setNameFormat("DynamicLog4jListener").build();
        this.executorPool = new ThreadPoolExecutor(0, 1, 900L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public void configure() {
        this.configure(null);
    }

    public void configure(Properties props) {
        String[] asyncAppenderArray;
        String log4jLoggerFactory;
        this.originalAsyncAppenderNameMap.clear();
        String log4jConfigurationFile = System.getProperty(PROP_LOG4J_CONFIGURATION);
        if (log4jConfigurationFile != null) {
            InputStream in = null;
            try {
                URL url = new URL(log4jConfigurationFile);
                in = url.openStream();
                this.props.load(in);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot load log4 configuration file specified in log4j.configuration", t);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (props != null) {
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String propertyValue = props.getProperty(key);
                this.props.setProperty(key, propertyValue);
            }
        }
        this.blitz4jConfig = new DefaultBlitz4jConfig(this.props);
        NFHierarchy nfHierarchy = null;
        if (this.blitz4jConfig.shouldUseLockFree() && !NFHierarchy.class.equals(LogManager.getLoggerRepository().getClass())) {
            nfHierarchy = new NFHierarchy(new NFRootLogger(Level.INFO));
            LogManager.setRepositorySelector((RepositorySelector)new NFRepositorySelector((LoggerRepository)nfHierarchy), (Object)guard);
        }
        if ((log4jLoggerFactory = System.getProperty("log4j.loggerFactory")) != null) {
            this.props.setProperty("log4j.loggerFactory", log4jLoggerFactory);
            if (nfHierarchy != null) {
                try {
                    LoggerFactory loggerFactory = (LoggerFactory)Class.forName(log4jLoggerFactory).newInstance();
                    nfHierarchy.setLoggerFactory(loggerFactory);
                }
                catch (Throwable e) {
                    System.err.println("Cannot set the logger factory. Hence reverting to default.");
                    e.printStackTrace();
                }
            }
        } else if (this.blitz4jConfig.shouldUseLockFree()) {
            this.props.setProperty("log4j.loggerFactory", BLITZ_LOGGER_FACTORY);
        }
        if ((asyncAppenderArray = this.blitz4jConfig.getAsyncAppenders()) == null) {
            return;
        }
        for (int i = 0; i < asyncAppenderArray.length; ++i) {
            String oneAppenderName = asyncAppenderArray[i];
            if (i == 0) continue;
            String oneAsyncAppenderName = oneAppenderName + ASYNC_APPENDERNAME_SUFFIX;
            this.originalAsyncAppenderNameMap.put(oneAppenderName, oneAsyncAppenderName);
        }
        try {
            this.convertConfiguredAppendersToAsync(this.props);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not configure async appenders ", e);
        }
        this.blitz4jConfig = new DefaultBlitz4jConfig(this.props);
        PropertyConfigurator.configure((Properties)this.props);
        this.closeNonexistingAsyncAppenders();
        this.logger = org.slf4j.LoggerFactory.getLogger(LoggingConfiguration.class);
        ConfigurationManager.getConfigInstance().addConfigurationListener((ConfigurationListener)new ExpandedConfigurationListenerAdapter((PropertyListener)this));
    }

    public static LoggingConfiguration getInstance() {
        return instance;
    }

    public BlitzConfig getConfiguration() {
        return this.blitz4jConfig;
    }

    public void stop() {
        String batcherName;
        MessageBatcher batcher = null;
        for (String originalAppenderName : this.originalAsyncAppenderNameMap.keySet()) {
            batcherName = AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName;
            batcher = BatcherFactory.getBatcher(batcherName);
            if (batcher == null) continue;
            batcher.stop();
        }
        for (String originalAppenderName : this.originalAsyncAppenderNameMap.keySet()) {
            batcherName = AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName;
            batcher = BatcherFactory.getBatcher(batcherName);
            if (batcher == null) continue;
            BatcherFactory.removeBatcher(batcherName);
        }
    }

    public void addProperty(Object source, String name, Object value, boolean beforeUpdate) {
        if (this.shouldProcessProperty(name, beforeUpdate)) {
            this.updatedProps.put(name, value);
            this.reConfigureAsynchronously();
        }
    }

    public void clear(Object source, boolean beforeUpdate) {
    }

    public void clearProperty(Object source, String name, Object value, boolean beforeUpdate) {
        if (this.shouldProcessProperty(name, beforeUpdate)) {
            this.updatedProps.remove(name);
            this.reConfigureAsynchronously();
        }
    }

    public void configSourceLoaded(Object source) {
    }

    public void setProperty(Object source, String name, Object value, boolean beforeUpdate) {
        if (this.shouldProcessProperty(name, beforeUpdate)) {
            this.updatedProps.put(name, value);
            this.reConfigureAsynchronously();
        }
    }

    private void reConfigure() throws ConfigurationException, FileNotFoundException {
        MessageBatcher asyncBatcher;
        Properties consolidatedProps = new Properties();
        consolidatedProps.putAll((Map<?, ?>)this.props);
        this.logger.info("Updated properties is :" + this.updatedProps);
        consolidatedProps.putAll((Map<?, ?>)this.updatedProps);
        this.logger.info("The root category for log4j.rootCategory now is " + consolidatedProps.getProperty("log4j.rootCategory"));
        this.logger.info("The root category for log4j.rootLogger now is " + consolidatedProps.getProperty("log4j.rootLogger"));
        for (String originalAppenderName : this.originalAsyncAppenderNameMap.keySet()) {
            asyncBatcher = BatcherFactory.getBatcher(AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName);
            if (asyncBatcher == null) continue;
            asyncBatcher.pause();
        }
        this.configureLog4j(consolidatedProps);
        for (String originalAppenderName : this.originalAsyncAppenderNameMap.keySet()) {
            asyncBatcher = BatcherFactory.getBatcher(AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName);
            if (asyncBatcher == null) continue;
            asyncBatcher.resume();
        }
    }

    private void configureLog4j(Properties props) throws ConfigurationException, FileNotFoundException {
        if (this.blitz4jConfig.shouldUseLockFree() && props.getProperty("log4j.loggerFactory") == null) {
            props.setProperty("log4j.loggerFactory", LOG4J_FACTORY_IMPL);
        }
        this.convertConfiguredAppendersToAsync(props);
        this.logger.info("Configuring log4j with properties :" + props);
        PropertyConfigurator.configure((Properties)props);
    }

    private void reConfigureAsynchronously() {
        this.executorPool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    LoggingConfiguration.this.logger.info("Configuring log4j dynamically");
                    LoggingConfiguration.this.reConfigure();
                }
                catch (Throwable th) {
                    LoggingConfiguration.this.logger.error("Cannot dynamically configure log4j :", th);
                }
            }
        });
    }

    private boolean shouldProcessProperty(String name, boolean beforeUpdate) {
        if (name == null) {
            this.logger.warn("The listener got a null value for name");
            return false;
        }
        if (beforeUpdate) {
            return false;
        }
        return name.startsWith(LOG4J_PREFIX);
    }

    private void convertConfiguredAppendersToAsync(Properties props) throws ConfigurationException, FileNotFoundException {
        for (Map.Entry<String, String> originalAsyncAppenderMapEntry : this.originalAsyncAppenderNameMap.entrySet()) {
            String asyncAppenderName = originalAsyncAppenderMapEntry.getValue();
            props.setProperty("log4j.appender." + asyncAppenderName, AsyncAppender.class.getName());
            String originalAppenderName = originalAsyncAppenderMapEntry.getKey();
            props.setProperty("log4j.appender." + asyncAppenderName + LOG4J_APPENDER_DELIMITER + PROP_LOG4J_ORIGINAL_APPENDER_NAME, originalAppenderName);
            this.props.setProperty("batcher." + AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName + LOG4J_APPENDER_DELIMITER + "rejectWhenFull", "true");
            String maxThreads = this.props.getProperty("batcher." + AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName + LOG4J_APPENDER_DELIMITER + "maxThreads");
            if (maxThreads == null) {
                this.props.setProperty("batcher." + AsyncAppender.class.getName() + LOG4J_APPENDER_DELIMITER + originalAppenderName + LOG4J_APPENDER_DELIMITER + "maxThreads", "1");
            }
            for (Map.Entry<Object, Object> mapEntry : props.entrySet()) {
                Object value;
                String key = mapEntry.getKey().toString();
                if (!key.contains(LOG4J_PREFIX) && !key.contains(ROOT_CATEGORY) && !key.contains(ROOT_LOGGER) || key.contains(PROP_LOG4J_ASYNC_APPENDERS) || key.contains(PROP_LOG4J_ORIGINAL_APPENDER_NAME) || (value = mapEntry.getValue()) == null) continue;
                String[] values = ((String)String.class.cast(value)).split(",");
                String valueString = "";
                int ctr = 0;
                for (String oneValue : values) {
                    ++ctr;
                    if (originalAppenderName.equals(oneValue)) {
                        oneValue = asyncAppenderName;
                    }
                    valueString = ctr != values.length ? valueString + oneValue + "," : valueString + oneValue;
                }
                mapEntry.setValue(valueString);
            }
        }
    }

    private void closeNonexistingAsyncAppenders() {
        org.apache.log4j.Logger rootLogger = LogManager.getRootLogger();
        if (NFLockFreeLogger.class.isInstance(rootLogger)) {
            ((NFLockFreeLogger)rootLogger).reconcileAppenders();
        }
        Enumeration enums = LogManager.getCurrentLoggers();
        while (enums.hasMoreElements()) {
            Object myLogger = enums.nextElement();
            if (!NFLockFreeLogger.class.isInstance(myLogger)) continue;
            ((NFLockFreeLogger)((Object)myLogger)).reconcileAppenders();
        }
    }
}

